/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class IndexTemplateConfig {
    private final String templateName;
    private final String fileName;
    private final int version;
    private final String versionProperty;
    private final Map<String, String> variables;

    public IndexTemplateConfig(String templateName, String fileName, int version, String versionProperty) {
        this(templateName, fileName, version, versionProperty, Collections.emptyMap());
    }

    public IndexTemplateConfig(String templateName, String fileName, int version, String versionProperty, Map<String, String> variables) {
        this.templateName = templateName;
        this.fileName = fileName;
        this.version = version;
        this.versionProperty = versionProperty;
        this.variables = Objects.requireNonNull(variables);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] loadBytes() {
        String template = TemplateUtils.loadTemplate(this.fileName, Integer.toString(this.version), this.versionProperty, this.variables);
        assert (template != null && template.length() > 0);
        assert (Pattern.compile("\"version\"\\s*:\\s*" + this.version).matcher(template).find()) : "index template must have a version property set to the given version property";
        return template.getBytes(StandardCharsets.UTF_8);
    }
}

