/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.XPackInfoRequestBuilder;

@ServerlessScope(value=Scope.INTERNAL)
public class RestXPackInfoAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestXPackInfoAction.class);

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_xpack"), new RestHandler.Route(RestRequest.Method.HEAD, "/_xpack"));
    }

    public String getName() {
        return "xpack_info_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean verbose = request.paramAsBoolean("human", true);
        if (request.hasParam("accept_enterprise")) {
            deprecationLogger.warn(DeprecationCategory.API, "get_license_accept_enterprise", "Including [accept_enterprise] in get license requests is deprecated. The parameter will be removed in the next major version", new Object[0]);
            if (!request.paramAsBoolean("accept_enterprise", true)) {
                throw new IllegalArgumentException("The [accept_enterprise] parameters may not be false");
            }
        }
        EnumSet<XPackInfoRequest.Category> categories = XPackInfoRequest.Category.toSet(request.paramAsStringArray("categories", new String[]{"_all"}));
        return channel -> new XPackInfoRequestBuilder((ElasticsearchClient)client).setVerbose(verbose).setCategories(categories).execute((ActionListener)new RestToXContentListener(channel));
    }
}

