/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.geo;

import java.util.Random;
import org.elasticsearch.common.geo.GeoPoint;

public class RandomGeoGenerator {
    public static void randomPoint(Random r, double[] pt) {
        double[] min = new double[]{-180.0, -90.0};
        double[] max = new double[]{180.0, 90.0};
        RandomGeoGenerator.randomPointIn(r, min[0], min[1], max[0], max[1], pt);
    }

    public static void randomPointIn(Random r, double minLon, double minLat, double maxLon, double maxLat, double[] pt) {
        assert (pt != null && pt.length == 2);
        double[] min = new double[]{RandomGeoGenerator.normalizeLongitude(minLon), RandomGeoGenerator.normalizeLatitude(minLat)};
        double[] max = new double[]{RandomGeoGenerator.normalizeLongitude(maxLon), RandomGeoGenerator.normalizeLatitude(maxLat)};
        double[] tMin = new double[2];
        double[] tMax = new double[2];
        tMin[0] = Math.min(min[0], max[0]);
        tMax[0] = Math.max(min[0], max[0]);
        tMin[1] = Math.min(min[1], max[1]);
        tMax[1] = Math.max(min[1], max[1]);
        pt[0] = tMin[0] + r.nextDouble() * (tMax[0] - tMin[0]);
        pt[1] = tMin[1] + r.nextDouble() * (tMax[1] - tMin[1]);
    }

    public static GeoPoint randomPoint(Random r) {
        return RandomGeoGenerator.randomPointIn(r, -180.0, -90.0, 180.0, 90.0);
    }

    public static GeoPoint randomPointIn(Random r, double minLon, double minLat, double maxLon, double maxLat) {
        double[] pt = new double[2];
        RandomGeoGenerator.randomPointIn(r, minLon, minLat, maxLon, maxLat, pt);
        return new GeoPoint(pt[1], pt[0]);
    }

    private static double normalizeLatitude(double latitude) {
        if (latitude >= -90.0 && latitude <= 90.0) {
            return latitude;
        }
        double off = Math.abs((latitude + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    private static double normalizeLongitude(double longitude) {
        if (longitude >= -180.0 && longitude <= 180.0) {
            return longitude;
        }
        double off = (longitude + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && longitude > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }
}

