/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class MockFieldMapper
extends FieldMapper {
    public MockFieldMapper(String fullName) {
        this((MappedFieldType)new FakeFieldType(fullName));
    }

    public MockFieldMapper(MappedFieldType fieldType) {
        this(MockFieldMapper.findSimpleName(fieldType.name()), fieldType, FieldMapper.BuilderParams.empty());
    }

    public MockFieldMapper(MappedFieldType fieldType, String simpleName) {
        super(simpleName, fieldType, FieldMapper.BuilderParams.empty());
    }

    public MockFieldMapper(String fullName, MappedFieldType fieldType, FieldMapper.BuilderParams params) {
        super(MockFieldMapper.findSimpleName(fullName), fieldType, params);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName());
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(DocumentParserContext context) {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return "faketype";
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final MappedFieldType fieldType;

        protected Builder(String name) {
            super(name);
            this.fieldType = new FakeFieldType(name);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        public Builder addMultiField(Builder builder) {
            this.multiFieldsBuilder.add((FieldMapper.Builder)builder);
            return this;
        }

        public Builder copyTo(String field) {
            this.copyTo = this.copyTo.withAddedFields(List.of(field));
            return this;
        }

        public MockFieldMapper build(MapperBuilderContext context) {
            return new MockFieldMapper(this.leafName(), this.fieldType, this.builderParams((Mapper.Builder)this, context));
        }
    }
}

