/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class UnsupportedEsField
extends EsField {
    private static final TransportVersion ESQL_REPORT_ORIGINAL_TYPES = TransportVersion.fromName((String)"esql_report_original_types");
    private final List<String> originalTypes;
    private final String inherited;

    public UnsupportedEsField(String name, List<String> originalTypes) {
        this(name, originalTypes, null, new TreeMap<String, EsField>());
    }

    public UnsupportedEsField(String name, List<String> originalTypes, String inherited, Map<String, EsField> properties) {
        super(name, DataType.UNSUPPORTED, properties, false);
        this.originalTypes = originalTypes;
        this.inherited = inherited;
    }

    public UnsupportedEsField(StreamInput in) throws IOException {
        this(PlanStreamInput.readCachedStringWithVersionCheck(in), UnsupportedEsField.readOriginalTypes(in), in.readOptionalString(), in.readImmutableMap(EsField::readFrom));
    }

    private static List<String> readOriginalTypes(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(ESQL_REPORT_ORIGINAL_TYPES)) {
            return in.readCollectionAsList(i -> ((PlanStreamInput)i).readCachedString());
        }
        return List.of(PlanStreamInput.readCachedStringWithVersionCheck(in).split(","));
    }

    @Override
    public void writeContent(StreamOutput out) throws IOException {
        PlanStreamOutput.writeCachedStringWithVersionCheck(out, this.getName());
        if (out.getTransportVersion().supports(ESQL_REPORT_ORIGINAL_TYPES)) {
            out.writeCollection(this.getOriginalTypes(), (o, s) -> ((PlanStreamOutput)o).writeCachedString((String)s));
        } else {
            PlanStreamOutput.writeCachedStringWithVersionCheck(out, String.join((CharSequence)",", this.getOriginalTypes()));
        }
        out.writeOptionalString(this.getInherited());
        out.writeMap(this.getProperties(), (o, x) -> x.writeTo(out));
    }

    @Override
    public String getWriteableName() {
        return "UnsupportedEsField";
    }

    public List<String> getOriginalTypes() {
        return this.originalTypes;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean hasInherited() {
        return this.inherited != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnsupportedEsField that = (UnsupportedEsField)o;
        return Objects.equals(this.originalTypes, that.originalTypes) && Objects.equals(this.inherited, that.inherited);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originalTypes, this.inherited);
    }
}

