/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.esql.EsqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsAction;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsRequest;
import org.elasticsearch.xpack.esql.plugin.EsqlStatsResponse;

public class EsqlUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public EsqlUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super(XPackUsageFeatureAction.ESQL.name(), transportService, clusterService, threadPool, actionFilters);
        this.client = client;
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        EsqlStatsRequest esqlRequest = new EsqlStatsRequest();
        esqlRequest.includeStats(true);
        esqlRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute((ActionType)EsqlStatsAction.INSTANCE, (ActionRequest)esqlRequest, listener.delegateFailureAndWrap((l, r) -> {
            List countersPerNode = r.getNodes().stream().map(EsqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
            Counters mergedCounters = Counters.merge(countersPerNode);
            EsqlFeatureSetUsage usage = new EsqlFeatureSetUsage(mergedCounters.toNestedMap());
            l.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
        }));
    }
}

