/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Collections;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public final class ResizeRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;
    private final boolean dlsFlsEnabled;

    public ResizeRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState, AuditTrailService auditTrailService, boolean dlsFlsEnabled) {
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
        this.auditTrailService = auditTrailService;
        this.dlsFlsEnabled = dlsFlsEnabled;
    }

    @Override
    public SubscribableListener<Void> intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        TransportRequest transportRequest = requestInfo.getRequest();
        if (transportRequest instanceof ResizeRequest) {
            IndicesAccessControl indicesAccessControl;
            IndicesAccessControl.IndexAccessControl indexAccessControl;
            ResizeRequest request = (ResizeRequest)transportRequest;
            AuditTrail auditTrail = this.auditTrailService.get();
            boolean isDlsLicensed = SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
            boolean isFlsLicensed = SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
            if (this.dlsFlsEnabled && (isDlsLicensed || isFlsLicensed) && (indexAccessControl = (indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions")).getIndexPermissions(request.getSourceIndex())) != null && (indexAccessControl.getFieldPermissions().hasFieldLevelSecurity() || indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions())) {
                return SubscribableListener.newFailed((Exception)((Object)new ElasticsearchSecurityException("Resize requests are not allowed for users when field or document level security is enabled on the source index", RestStatus.BAD_REQUEST, new Object[0])));
            }
            SubscribableListener listener = new SubscribableListener();
            authorizationEngine.validateIndexPermissionsAreSubset(requestInfo, authorizationInfo, Collections.singletonMap(request.getSourceIndex(), Collections.singletonList(request.getTargetIndexRequest().index())), (ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(authzResult -> {
                if (authzResult.isGranted()) {
                    listener.onResponse(null);
                } else {
                    auditTrail.accessDenied(AuditUtil.extractRequestId(this.threadContext), requestInfo.getAuthentication(), requestInfo.getAction(), (TransportRequest)request, authorizationInfo);
                    listener.onFailure((Exception)((Object)Exceptions.authorizationError((String)"Resizing an index is not allowed when the target index has more permissions than the source index", (Object[])new Object[0])));
                }
            }, arg_0 -> ((SubscribableListener)listener).onFailure(arg_0)), (ThreadContext)this.threadContext));
            return listener;
        }
        return SubscribableListener.nullSuccess();
    }
}

