/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.elasticsearch.compute.data.AbstractVectorBuilder;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleVector;

final class DoubleVectorBuilder
extends AbstractVectorBuilder
implements DoubleVector.Builder {
    private double[] values;

    DoubleVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(initialSize);
        this.values = new double[Math.max(estimatedSize, 2)];
    }

    @Override
    public DoubleVectorBuilder appendDouble(double value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        ++this.valueCount;
        return this;
    }

    @Override
    protected int elementSize() {
        return 8;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public DoubleVector build() {
        DoubleVector vector;
        this.finish();
        if (this.valueCount == 1) {
            vector = this.blockFactory.newConstantDoubleBlockWith(this.values[0], 1, this.estimatedBytes).asVector();
        } else {
            if (this.values.length - this.valueCount > 1024 || this.valueCount < this.values.length / 2) {
                this.values = Arrays.copyOf(this.values, this.valueCount);
            }
            vector = this.blockFactory.newDoubleArrayVector(this.values, this.valueCount, this.estimatedBytes);
        }
        this.built();
        return vector;
    }
}

