/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.grouping;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.lucene.grouping.GroupingDocValuesSelector;
import org.elasticsearch.lucene.grouping.TopFieldGroups;

public class SinglePassGroupingCollector<T>
extends SimpleCollector {
    private final String groupField;
    private final FieldDoc after;
    private final Sort groupSort;
    private final GroupSelector<T> groupSelector;
    private final FieldComparator<?>[] comparators;
    private final LeafFieldComparator[] leafComparators;
    private final int[] reversed;
    private final int topNGroups;
    private final boolean needsScores;
    private final Map<T, SearchGroup<T>> groupMap;
    private final int compIDXEnd;
    private int totalHitCount;
    private TreeSet<SearchGroup<T>> orderedGroups;
    private int docBase;
    private int spareSlot;

    public static SinglePassGroupingCollector<?> createNumeric(String groupField, MappedFieldType groupFieldType, Sort groupSort, int topN, @Nullable FieldDoc after) {
        return new SinglePassGroupingCollector<Long>(new GroupingDocValuesSelector.Numeric(groupFieldType), groupField, groupSort, topN, after);
    }

    public static SinglePassGroupingCollector<?> createKeyword(String groupField, MappedFieldType groupFieldType, Sort groupSort, int topN, @Nullable FieldDoc after) {
        return new SinglePassGroupingCollector<BytesRef>(new GroupingDocValuesSelector.Keyword(groupFieldType), groupField, groupSort, topN, after);
    }

    private SinglePassGroupingCollector(GroupSelector<T> groupSelector, String groupField, Sort groupSort, int topNGroups, @Nullable FieldDoc after) {
        assert (after == null || groupSort.getSort().length == 1 && after.doc == Integer.MAX_VALUE);
        this.groupSelector = groupSelector;
        this.groupField = groupField;
        this.groupSort = groupSort;
        this.after = after;
        if (topNGroups < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + topNGroups + ")");
        }
        this.topNGroups = topNGroups;
        this.needsScores = groupSort.needsScores();
        SortField[] sortFields = groupSort.getSort();
        this.comparators = new FieldComparator[sortFields.length];
        this.leafComparators = new LeafFieldComparator[sortFields.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            this.comparators[i] = sortField.getComparator(topNGroups + 1, Pruning.NONE);
            this.reversed[i] = sortField.getReverse() ? -1 : 1;
        }
        if (after != null) {
            FieldComparator<?> comparator = this.comparators[0];
            comparator.setTopValue(after.fields[0]);
        }
        this.spareSlot = topNGroups;
        this.groupMap = Maps.newMapWithExpectedSize(topNGroups);
    }

    public ScoreMode scoreMode() {
        return this.needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public TopFieldGroups getTopGroups(int groupOffset) throws IOException {
        if (groupOffset < 0) {
            throw new IllegalArgumentException("groupOffset must be >= 0 (got " + groupOffset + ")");
        }
        if (this.groupMap.size() <= groupOffset) {
            TotalHits totalHits = new TotalHits((long)this.totalHitCount, TotalHits.Relation.EQUAL_TO);
            return new TopFieldGroups(this.groupField, totalHits, Lucene.EMPTY_SCORE_DOCS, this.groupSort.getSort(), new Object[0]);
        }
        if (this.orderedGroups == null) {
            this.buildSortedSet();
        }
        int scorePos = -1;
        for (int index = 0; index < this.groupSort.getSort().length; ++index) {
            SortField sortField = this.groupSort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int size = Math.max(0, this.orderedGroups.size() - groupOffset);
        FieldDoc[] topDocs = new FieldDoc[size];
        Object[] groupValues = new Object[size];
        int sortFieldCount = this.comparators.length;
        int upto = 0;
        int pos = 0;
        for (SearchGroup<T> group : this.orderedGroups) {
            if (upto++ < groupOffset) continue;
            float score = Float.NaN;
            Object[] sortValues = new Object[sortFieldCount];
            for (int sortFieldIDX = 0; sortFieldIDX < sortFieldCount; ++sortFieldIDX) {
                sortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(group.slot);
                if (sortFieldIDX != scorePos) continue;
                score = ((Float)sortValues[sortFieldIDX]).floatValue();
            }
            topDocs[pos] = new FieldDoc(group.doc, score, sortValues);
            groupValues[pos++] = group.groupValue;
        }
        TotalHits totalHits = new TotalHits((long)this.totalHitCount, TotalHits.Relation.EQUAL_TO);
        return new TopFieldGroups(this.groupField, totalHits, (ScoreDoc[])topDocs, this.groupSort.getSort(), groupValues);
    }

    public void setScorer(Scorable scorer) throws IOException {
        this.groupSelector.setScorer(scorer);
        for (LeafFieldComparator comparator : this.leafComparators) {
            comparator.setScorer(scorer);
        }
    }

    private boolean isCompetitive(int doc) throws IOException {
        int cmp;
        if (this.after != null && (cmp = this.reversed[0] * this.leafComparators[0].compareTop(doc)) >= 0) {
            return false;
        }
        if (this.orderedGroups != null) {
            int compIDX = 0;
            while (true) {
                int c;
                if ((c = this.reversed[compIDX] * this.leafComparators[compIDX].compareBottom(doc)) < 0) {
                    return false;
                }
                if (c > 0) break;
                if (compIDX == this.compIDXEnd) {
                    return false;
                }
                ++compIDX;
            }
        }
        return true;
    }

    public void collect(int doc) throws IOException {
        SearchGroup<T> prevLast;
        ++this.totalHitCount;
        if (!this.isCompetitive(doc)) {
            return;
        }
        this.groupSelector.advanceTo(doc);
        Object groupValue = this.groupSelector.currentValue();
        SearchGroup<T> group = this.groupMap.get(groupValue);
        if (group == null) {
            if (this.groupMap.size() < this.topNGroups) {
                SearchGroup<Object> sg = new SearchGroup<Object>(this.docBase + doc, this.groupMap.size(), this.groupSelector.copyValue());
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.copy(sg.slot, doc);
                }
                this.groupMap.put(sg.groupValue, sg);
                if (this.groupMap.size() == this.topNGroups) {
                    this.buildSortedSet();
                }
                return;
            }
            SearchGroup<T> bottomGroup = this.orderedGroups.pollLast();
            assert (this.orderedGroups.size() == this.topNGroups - 1);
            this.groupMap.remove(bottomGroup.groupValue);
            bottomGroup.groupValue = this.groupSelector.copyValue();
            bottomGroup.doc = this.docBase + doc;
            for (LeafFieldComparator fc : this.leafComparators) {
                fc.copy(bottomGroup.slot, doc);
            }
            this.groupMap.put(bottomGroup.groupValue, bottomGroup);
            this.orderedGroups.add(bottomGroup);
            assert (this.orderedGroups.size() == this.topNGroups);
            int lastComparatorSlot = this.orderedGroups.last().slot;
            for (LeafFieldComparator fc : this.leafComparators) {
                fc.setBottom(lastComparatorSlot);
            }
            return;
        }
        int compIDX = 0;
        while (true) {
            this.leafComparators[compIDX].copy(this.spareSlot, doc);
            int c = this.reversed[compIDX] * this.comparators[compIDX].compare(group.slot, this.spareSlot);
            if (c < 0) {
                return;
            }
            if (c > 0) {
                for (int compIDX2 = compIDX + 1; compIDX2 < this.comparators.length; ++compIDX2) {
                    this.leafComparators[compIDX2].copy(this.spareSlot, doc);
                }
                break;
            }
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        if (this.orderedGroups != null) {
            prevLast = this.orderedGroups.last();
            this.orderedGroups.remove(group);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
        } else {
            prevLast = null;
        }
        group.doc = this.docBase + doc;
        int tmp = this.spareSlot;
        this.spareSlot = group.slot;
        group.slot = tmp;
        if (this.orderedGroups != null) {
            this.orderedGroups.add(group);
            assert (this.orderedGroups.size() == this.topNGroups);
            SearchGroup<T> newLast = this.orderedGroups.last();
            if (group == newLast || prevLast != newLast) {
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.setBottom(newLast.slot);
                }
            }
        }
    }

    private void buildSortedSet() throws IOException {
        Comparator comparator = (o1, o2) -> {
            int compIDX = 0;
            FieldComparator<?> fc;
            int c;
            while ((c = this.reversed[compIDX] * (fc = this.comparators[compIDX]).compare(o1.slot, o2.slot)) == 0) {
                if (compIDX == this.compIDXEnd) {
                    return o1.doc - o2.doc;
                }
                ++compIDX;
            }
            return c;
        };
        this.orderedGroups = new TreeSet(comparator);
        this.orderedGroups.addAll(this.groupMap.values());
        assert (this.orderedGroups.size() > 0);
        for (LeafFieldComparator fc : this.leafComparators) {
            fc.setBottom(this.orderedGroups.last().slot);
        }
    }

    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        this.docBase = readerContext.docBase;
        for (int i = 0; i < this.comparators.length; ++i) {
            this.leafComparators[i] = this.comparators[i].getLeafComparator(readerContext);
        }
        this.groupSelector.setNextReader(readerContext);
    }

    public GroupSelector<T> getGroupSelector() {
        return this.groupSelector;
    }

    private static class SearchGroup<T>
    extends ScoreDoc {
        T groupValue;
        int slot;

        SearchGroup(int doc, int slot, T groupValue) {
            super(doc, Float.NaN);
            this.slot = slot;
            this.groupValue = groupValue;
        }

        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }
}

