/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.query;

import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.serialization.Generator;

public class QueryStringQueryBuilder
extends QueryBuilder {
    private String query;
    private String defaultField;
    private String analyzer;
    private Boolean lowercaseExpandedTerms;
    private Boolean analyzeWildcard;
    private String defaultOperator;
    private Boolean lenient;

    public QueryStringQueryBuilder query(String value) {
        if (value == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null");
        }
        this.query = value;
        return this;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public QueryStringQueryBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public QueryStringQueryBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public QueryStringQueryBuilder defaultOperator(String defaultOperator) {
        this.defaultOperator = defaultOperator;
        return this;
    }

    @Override
    public void toJson(Generator out) {
        if (this.query == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null");
        }
        out.writeFieldName("query_string");
        out.writeBeginObject();
        out.writeFieldName("query");
        out.writeString(this.query);
        if (this.defaultField != null) {
            out.writeFieldName("default_field");
            out.writeString(this.defaultField);
        }
        if (this.analyzer != null) {
            out.writeFieldName("analyzer");
            out.writeString(this.analyzer);
        }
        if (this.lowercaseExpandedTerms != null) {
            out.writeFieldName("lowercaseExpandedTerms");
            out.writeBoolean(this.lowercaseExpandedTerms);
        }
        if (this.analyzeWildcard != null) {
            out.writeFieldName("analyzeWildcard");
            out.writeBoolean(this.analyzeWildcard);
        }
        if (this.defaultOperator != null) {
            out.writeFieldName("defaultOperator");
            out.writeString(this.defaultOperator);
        }
        if (this.lenient != null) {
            out.writeFieldName("lenient");
            out.writeBoolean(this.lenient);
        }
        out.writeEndObject();
    }

    public void lenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryStringQueryBuilder that = (QueryStringQueryBuilder)o;
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.defaultField != null ? !this.defaultField.equals(that.defaultField) : that.defaultField != null) {
            return false;
        }
        if (this.analyzer != null ? !this.analyzer.equals(that.analyzer) : that.analyzer != null) {
            return false;
        }
        if (this.lowercaseExpandedTerms != null ? !this.lowercaseExpandedTerms.equals(that.lowercaseExpandedTerms) : that.lowercaseExpandedTerms != null) {
            return false;
        }
        if (this.analyzeWildcard != null ? !this.analyzeWildcard.equals(that.analyzeWildcard) : that.analyzeWildcard != null) {
            return false;
        }
        if (this.defaultOperator != null ? !this.defaultOperator.equals(that.defaultOperator) : that.defaultOperator != null) {
            return false;
        }
        return this.lenient != null ? this.lenient.equals(that.lenient) : that.lenient == null;
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.defaultField != null ? this.defaultField.hashCode() : 0);
        result = 31 * result + (this.analyzer != null ? this.analyzer.hashCode() : 0);
        result = 31 * result + (this.lowercaseExpandedTerms != null ? this.lowercaseExpandedTerms.hashCode() : 0);
        result = 31 * result + (this.analyzeWildcard != null ? this.analyzeWildcard.hashCode() : 0);
        result = 31 * result + (this.defaultOperator != null ? this.defaultOperator.hashCode() : 0);
        result = 31 * result + (this.lenient != null ? this.lenient.hashCode() : 0);
        return result;
    }
}

