"use strict";
/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const colors_1 = require("kleur/colors");
const base_1 = __importStar(require("./base"));
const helpers_1 = require("../helpers");
const reporter_util_1 = require("./reporter-util");
class BuildKiteCLIReporter extends base_1.default {
    journeys = new Map();
    constructor(options = {}) {
        super(options);
    }
    onJourneyStart(journey, {}) {
        this.write(`\n--- Journey: ${journey.name}`);
    }
    onStepEnd(journey, step, result) {
        super.onStepEnd(journey, step, result);
        if (!this.journeys.has(journey.name)) {
            this.journeys.set(journey.name, []);
        }
        this.journeys.get(journey.name)?.push(step);
    }
    async onJourneyEnd(journey, result) {
        super.onJourneyEnd(journey, result);
        const message = `${helpers_1.symbols[journey.status]} Took (${(0, base_1.renderDuration)(journey.duration)} seconds)`;
        this.write(message);
    }
    onEnd() {
        const { failed, succeeded, skipped } = this.metrics;
        const total = failed + succeeded + skipped;
        if (total > 0) {
            const failedJourneys = Array.from(this.journeys.entries()).filter(([, steps]) => steps.some(step => step.status === 'failed'));
            // if more than 5 journeys, we also report failed journeys at the end
            if (failedJourneys.length > 0 && this.journeys.size > 5) {
                failedJourneys.forEach(([journeyName, steps]) => {
                    const name = (0, colors_1.red)(`Journey: ${journeyName} :slightly_frowning_face:`);
                    this.write(`\n+++ ${name}`);
                    steps.forEach(step => {
                        const message = `${helpers_1.symbols[step.status]}  Step: '${step.name}' ${step.status} (${(0, base_1.renderDuration)(step.duration * 1000)} ms)`;
                        this.write((0, helpers_1.indent)(message));
                        if (step.error) {
                            this.write((0, reporter_util_1.renderError)((0, reporter_util_1.serializeError)(step.error)));
                        }
                    });
                });
            }
        }
        let message = '\n';
        if (total === 0) {
            message = 'No tests found!';
            message += ` (${(0, base_1.renderDuration)((0, helpers_1.now)())} ms) \n`;
            this.write(message);
            return;
        }
        message += succeeded > 0 ? (0, colors_1.green)(` ${succeeded} passed`) : '';
        message += failed > 0 ? (0, colors_1.red)(` ${failed} failed`) : '';
        message += skipped > 0 ? (0, colors_1.cyan)(` ${skipped} skipped`) : '';
        message += ` (${(0, base_1.renderDuration)((0, helpers_1.now)() / 1000)} seconds) \n`;
        this.write(message);
    }
}
exports.default = BuildKiteCLIReporter;
//# sourceMappingURL=build_kite_cli.js.map