/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
import { Browser, Page, BrowserContext, CDPSession, APIRequestContext } from 'playwright-core';
import { Step } from './step';
import { VoidCallback, HooksCallback, Params, Location, StatusValue } from '../common_types';
import { Monitor, MonitorConfig } from './monitor';
import { RunnerInfo } from '../core/runner';
export type JourneyOptions = {
    name: string;
    id?: string;
    tags?: string[];
};
type HookType = 'before' | 'after';
export type Hooks = Record<HookType, Array<HooksCallback>>;
type JourneyCallbackOpts = {
    page: Page;
    context: BrowserContext;
    browser: Browser;
    client: CDPSession;
    params: Params;
    request: APIRequestContext;
    info: RunnerInfo;
};
export type JourneyCallback = (options: JourneyCallbackOpts) => void;
export declare class Journey {
    #private;
    readonly name: string;
    readonly id?: string;
    readonly tags?: string[];
    readonly location?: Location;
    readonly steps: Step[];
    skip: boolean;
    only: boolean;
    _startTime: number;
    duration: number;
    status: StatusValue;
    error?: Error;
    constructor(options: JourneyOptions, cb: JourneyCallback, location?: Location);
    _addStep(name: string, cb: VoidCallback, location?: Location): Step;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _addStep for backwards compatibility
     */
    addStep(name: string, cb: VoidCallback, location?: Location): void;
    _addHook(type: HookType, cb: HooksCallback): void;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _addHook for backwards compatibility
     */
    addHook(type: HookType, cb: HooksCallback): void;
    _getHook(type: HookType): HooksCallback[];
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _getHook for backwards compatibility
     */
    getHook(type: HookType): void;
    _getMonitor(): Monitor;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _getHook for backwards compatibility
     */
    get monitor(): Monitor;
    _updateMonitor(config: MonitorConfig): void;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _updateMonitor for backwards compatibility
     */
    updateMonitor(config: MonitorConfig): void;
    get cb(): JourneyCallback;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias cb for backwards compatibility
     */
    get callback(): JourneyCallback;
    /**
     * Matches journeys based on the provided args. Proitize tags over match
     */
    _isMatch(matchPattern: string, tagsPattern: Array<string>): boolean;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _isMatch for backwards compatibility
     */
    isMatch(matchPattern: string, tagsPattern: Array<string>): boolean;
}
type JourneyType = (options: string | JourneyOptions, callback: JourneyCallback) => Journey;
export type JourneyWithAnnotations = JourneyType & {
    /**
     * Skip this journey and all its steps
     */
    skip: JourneyType;
    /**
     * Run only this journey and skip rest of the journeys
     */
    only: JourneyType;
};
export {};
//# sourceMappingURL=journey.d.ts.map