/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.JarStorageFactory;
import org.apache.derby.io.StorageFile;

class JarDBFile
extends InputStreamFile<JarStorageFactory> {
    JarDBFile(JarStorageFactory storageFactory, String path) {
        super(storageFactory, path);
    }

    JarDBFile(JarStorageFactory storageFactory, String parent, String name) {
        super(storageFactory, parent, name);
    }

    JarDBFile(JarDBFile dir, String name) {
        super(dir, name);
    }

    private JarDBFile(JarStorageFactory storageFactory, String child, int pathLen) {
        super(storageFactory, child, pathLen);
    }

    @Override
    public boolean exists() {
        return this.getEntry() != null;
    }

    private ZipEntry getEntry() {
        return ((JarStorageFactory)this.storageFactory).zipData.getEntry(this.path);
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new JarDBFile((JarStorageFactory)this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return ((JarStorageFactory)this.storageFactory).zipData.getInputStream(zipEntry);
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
    }

    @Override
    public String toString() {
        return this.path;
    }
}

