/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class IsWholeNumber
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "is-whole-number");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_NUMERIC};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new IsWholeNumberCall();
    }

    private static class IsWholeNumberCall
    extends ExtensionFunctionCall {
        private IsWholeNumberCall() {
        }

        public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            return BooleanValue.get(this.effectiveBooleanValue(context, arguments));
        }

        public boolean effectiveBooleanValue(XPathContext context, Sequence[] arguments) throws XPathException {
            NumericValue val = (NumericValue)arguments[0].head();
            return val != null && val.isWholeNumber();
        }
    }
}

