/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.AbstractTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.DebertaV2Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DebertaV2TokenizationUpdate
extends AbstractTokenizationUpdate {
    public static final ParseField NAME = new ParseField("deberta_v2", new String[0]);
    public static final ConstructingObjectParser<DebertaV2TokenizationUpdate, Void> PARSER = new ConstructingObjectParser("deberta_v2_tokenization_update", a -> new DebertaV2TokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0]), (Integer)a[1]));

    public static DebertaV2TokenizationUpdate fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public DebertaV2TokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(truncate, span);
    }

    public DebertaV2TokenizationUpdate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (originalConfig instanceof DebertaV2Tokenization) {
            DebertaV2Tokenization debertaV2Tokenization = (DebertaV2Tokenization)originalConfig;
            if (this.isNoop()) {
                return debertaV2Tokenization;
            }
            Tokenization.validateSpanAndTruncate(this.getTruncate(), this.getSpan());
            if (this.getTruncate() != null && !this.getTruncate().isInCompatibleWithSpan()) {
                return new DebertaV2Tokenization(debertaV2Tokenization.doLowerCase(), debertaV2Tokenization.withSpecialTokens(), debertaV2Tokenization.maxSequenceLength(), this.getTruncate(), null);
            }
            return new DebertaV2Tokenization(debertaV2Tokenization.doLowerCase(), debertaV2Tokenization.withSpecialTokens(), debertaV2Tokenization.maxSequenceLength(), Optional.ofNullable(this.getTruncate()).orElse(originalConfig.getTruncate()), Optional.ofNullable(this.getSpan()).orElse(originalConfig.getSpan()));
        }
        throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        DebertaV2TokenizationUpdate.declareCommonParserFields(PARSER);
    }
}

