/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PredictionFieldType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ResultsFieldUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;

public class ClassificationConfig
implements LenientlyParsedInferenceConfig,
StrictlyParsedInferenceConfig {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    public static final ParseField NUM_TOP_CLASSES = new ParseField("num_top_classes", new String[0]);
    public static final ParseField TOP_CLASSES_RESULTS_FIELD = new ParseField("top_classes_results_field", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static final ParseField PREDICTION_FIELD_TYPE = new ParseField("prediction_field_type", new String[0]);
    private static final MlConfigVersion MIN_SUPPORTED_VERSION = MlConfigVersion.V_7_6_0;
    public static final ClassificationConfig EMPTY_PARAMS = new ClassificationConfig(0, "predicted_value", "top_classes", null, null);
    private final int numTopClasses;
    private final String topClassesResultsField;
    private final String resultsField;
    private final int numTopFeatureImportanceValues;
    private final PredictionFieldType predictionFieldType;
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = ClassificationConfig.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = ClassificationConfig.createParser(false);

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopClasses, NUM_TOP_CLASSES);
        parser.declareString(Builder::setResultsField, RESULTS_FIELD);
        parser.declareString(Builder::setTopClassesResultsField, TOP_CLASSES_RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareField(Builder::setPredictionFieldType, (p, c) -> {
            try {
                return PredictionFieldType.fromString(p.text());
            }
            catch (IllegalArgumentException iae) {
                if (lenient) {
                    return PredictionFieldType.STRING;
                }
                throw iae;
            }
        }, PREDICTION_FIELD_TYPE, ObjectParser.ValueType.STRING);
        return parser;
    }

    public static ClassificationConfig fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null).build();
    }

    public static ClassificationConfig fromXContentLenient(XContentParser parser) {
        return LENIENT_PARSER.apply(parser, null).build();
    }

    public ClassificationConfig(Integer numTopClasses) {
        this(numTopClasses, null, null, null, null);
    }

    public ClassificationConfig(Integer numTopClasses, String resultsField, String topClassesResultsField, Integer featureImportance, PredictionFieldType predictionFieldType) {
        this.numTopClasses = numTopClasses == null ? 0 : numTopClasses;
        this.topClassesResultsField = topClassesResultsField == null ? "top_classes" : topClassesResultsField;
        String string = this.resultsField = resultsField == null ? "predicted_value" : resultsField;
        if (featureImportance != null && featureImportance < 0) {
            throw new IllegalArgumentException("[" + NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numTopFeatureImportanceValues = featureImportance == null ? 0 : featureImportance;
        this.predictionFieldType = predictionFieldType == null ? PredictionFieldType.STRING : predictionFieldType;
    }

    public ClassificationConfig(StreamInput in) throws IOException {
        this.numTopClasses = in.readInt();
        this.topClassesResultsField = in.readString();
        this.resultsField = in.readString();
        this.numTopFeatureImportanceValues = in.readVInt();
        this.predictionFieldType = PredictionFieldType.fromStream(in);
    }

    @Override
    public InferenceConfig apply(InferenceConfigUpdate update) {
        if (update instanceof ClassificationConfigUpdate) {
            ClassificationConfigUpdate configUpdate = (ClassificationConfigUpdate)update;
            Builder builder = new Builder(this);
            if (configUpdate.getResultsField() != null) {
                builder.setResultsField(configUpdate.getResultsField());
            }
            if (configUpdate.getNumTopFeatureImportanceValues() != null) {
                builder.setNumTopFeatureImportanceValues(configUpdate.getNumTopFeatureImportanceValues());
            }
            if (configUpdate.getTopClassesResultsField() != null) {
                builder.setTopClassesResultsField(configUpdate.getTopClassesResultsField());
            }
            if (configUpdate.getNumTopClasses() != null) {
                builder.setNumTopClasses(configUpdate.getNumTopClasses());
            }
            if (configUpdate.getPredictionFieldType() != null) {
                builder.setPredictionFieldType(configUpdate.getPredictionFieldType());
            }
            return builder.build();
        }
        if (update instanceof ResultsFieldUpdate) {
            ResultsFieldUpdate resultsFieldUpdate = (ResultsFieldUpdate)update;
            return new Builder(this).setResultsField(resultsFieldUpdate.getResultsField()).build();
        }
        throw this.incompatibleUpdateException(update.getName());
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    public String getTopClassesResultsField() {
        return this.topClassesResultsField;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public int getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public PredictionFieldType getPredictionFieldType() {
        return this.predictionFieldType;
    }

    @Override
    public boolean requestingImportance() {
        return this.numTopFeatureImportanceValues > 0;
    }

    @Override
    public boolean isAllocateOnly() {
        return false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.numTopClasses);
        out.writeString(this.topClassesResultsField);
        out.writeString(this.resultsField);
        out.writeVInt(this.numTopFeatureImportanceValues);
        this.predictionFieldType.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationConfig that = (ClassificationConfig)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.topClassesResultsField, that.topClassesResultsField) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.predictionFieldType, that.predictionFieldType);
    }

    public int hashCode() {
        return Objects.hash(this.numTopClasses, this.topClassesResultsField, this.resultsField, this.numTopFeatureImportanceValues, this.predictionFieldType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        builder.field(TOP_CLASSES_RESULTS_FIELD.getPreferredName(), this.topClassesResultsField);
        builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        builder.field(PREDICTION_FIELD_TYPE.getPreferredName(), this.predictionFieldType.toString());
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return TargetType.CLASSIFICATION.equals(targetType);
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return this.requestingImportance() ? MlConfigVersion.V_7_7_0 : MIN_SUPPORTED_VERSION;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.ZERO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer numTopClasses;
        private String topClassesResultsField;
        private String resultsField;
        private PredictionFieldType predictionFieldType;
        private Integer numTopFeatureImportanceValues;

        Builder() {
        }

        Builder(ClassificationConfig config) {
            this.numTopClasses = config.numTopClasses;
            this.topClassesResultsField = config.topClassesResultsField;
            this.resultsField = config.resultsField;
            this.numTopFeatureImportanceValues = config.numTopFeatureImportanceValues;
            this.predictionFieldType = config.predictionFieldType;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setTopClassesResultsField(String topClassesResultsField) {
            this.topClassesResultsField = topClassesResultsField;
            return this;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldType(PredictionFieldType predictionFieldType) {
            this.predictionFieldType = predictionFieldType;
            return this;
        }

        public ClassificationConfig build() {
            return new ClassificationConfig(this.numTopClasses, this.resultsField, this.topClassesResultsField, this.numTopFeatureImportanceValues, this.predictionFieldType);
        }
    }
}

