/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;

public class LifecyclePolicyUsageCalculator {
    private final Map<String, List<String>> policyToTemplates;
    private final Map<String, List<String>> policyToDataStreams;
    private final Map<String, List<String>> policyToIndices;

    public LifecyclePolicyUsageCalculator(IndexNameExpressionResolver indexNameExpressionResolver, ProjectMetadata project, List<String> requestedPolicyNames) {
        IndexLifecycleMetadata ilmMetadata = (IndexLifecycleMetadata)project.custom("index_lifecycle");
        int expectedSize = Regex.isSimpleMatchPattern(requestedPolicyNames.get(0)) ? ilmMetadata.getPolicyMetadatas().size() : requestedPolicyNames.size();
        HashMap<String, String> templateToPolicy = new HashMap<String, String>();
        this.policyToTemplates = Maps.newHashMapWithExpectedSize(expectedSize);
        for (Map.Entry<String, ComposableIndexTemplate> entry2 : project.templatesV2().entrySet()) {
            Settings settings = MetadataIndexTemplateService.resolveSettings(entry2.getValue(), project.componentTemplates());
            String policyName = LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings);
            if (!this.doesPolicyMatchAnyName(policyName, requestedPolicyNames)) continue;
            this.policyToTemplates.computeIfAbsent(policyName, k -> new ArrayList()).add(entry2.getKey());
            templateToPolicy.put(entry2.getKey(), policyName);
        }
        ArrayList<Map.Entry<String, ComposableIndexTemplate>> indexTemplates = new ArrayList<Map.Entry<String, ComposableIndexTemplate>>(project.templatesV2().entrySet());
        CollectionUtil.timSort(indexTemplates, Comparator.comparing(entry -> ((ComposableIndexTemplate)entry.getValue()).priorityOrZero(), Comparator.reverseOrder()));
        this.policyToDataStreams = Maps.newHashMapWithExpectedSize(expectedSize);
        List<String> allDataStreams = indexNameExpressionResolver.dataStreamNames(project, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTOR, new String[0]);
        for (String dataStream : allDataStreams) {
            String indexTemplate = MetadataIndexTemplateService.findV2TemplateFromSortedList(project, indexTemplates, dataStream, false);
            if (indexTemplate == null) {
                assert (false) : "Data stream [" + dataStream + "] has no matching template";
                continue;
            }
            String policyName = (String)templateToPolicy.get(indexTemplate);
            if (policyName == null) continue;
            this.policyToDataStreams.computeIfAbsent(policyName, k -> new ArrayList()).add(dataStream);
        }
        this.policyToIndices = Maps.newHashMapWithExpectedSize(expectedSize);
        for (IndexMetadata indexMetadata : project.indices().values()) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            if (!this.doesPolicyMatchAnyName(policyName, requestedPolicyNames)) continue;
            this.policyToIndices.computeIfAbsent(policyName, k -> new ArrayList()).add(indexMetadata.getIndex().getName());
        }
    }

    public ItemUsage retrieveCalculatedUsage(String policyName) {
        return new ItemUsage(this.policyToIndices.getOrDefault(policyName, List.of()), this.policyToDataStreams.getOrDefault(policyName, List.of()), this.policyToTemplates.getOrDefault(policyName, List.of()));
    }

    private boolean doesPolicyMatchAnyName(String policyName, List<String> names) {
        for (String name : names) {
            if (!Regex.simpleMatch(name, policyName)) continue;
            return true;
        }
        return false;
    }
}

