/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.xpack.core.downsample.DownsampleBulkInfo;

public class DownsampleBulkStats {
    private final AtomicLong totalBulkCount = new AtomicLong(0L);
    private final AtomicLong bulkIngestSumMillis = new AtomicLong(0L);
    private final AtomicLong maxBulkIngestMillis = new AtomicLong(-1L);
    private final AtomicLong minBulkIngestMillis = new AtomicLong(-1L);
    private final AtomicLong bulkTookSumMillis = new AtomicLong(0L);
    private final AtomicLong maxBulkTookMillis = new AtomicLong(-1L);
    private final AtomicLong minBulkTookMillis = new AtomicLong(-1L);

    public void update(long bulkIngestMillis, long bulkTookMillis) {
        this.totalBulkCount.incrementAndGet();
        this.bulkIngestSumMillis.addAndGet(bulkIngestMillis);
        this.maxBulkIngestMillis.updateAndGet(existingValue -> DownsampleBulkStats.max(bulkIngestMillis, existingValue));
        this.minBulkIngestMillis.updateAndGet(existingValue -> DownsampleBulkStats.min(bulkIngestMillis, existingValue));
        this.bulkTookSumMillis.addAndGet(bulkTookMillis);
        this.maxBulkTookMillis.updateAndGet(existingValue -> DownsampleBulkStats.max(bulkTookMillis, existingValue));
        this.minBulkTookMillis.updateAndGet(existingValue -> DownsampleBulkStats.min(bulkTookMillis, existingValue));
    }

    private static long min(long newValue, long existingValue) {
        return existingValue == -1L ? newValue : Math.min(newValue, existingValue);
    }

    private static long max(long newValue, long existingValue) {
        return existingValue == -1L ? newValue : Math.max(newValue, existingValue);
    }

    public DownsampleBulkInfo getRollupBulkInfo() {
        return new DownsampleBulkInfo(this.totalBulkCount.get(), this.bulkIngestSumMillis.get(), Math.max(0L, this.maxBulkIngestMillis.get()), Math.max(0L, this.minBulkIngestMillis.get()), this.bulkTookSumMillis.get(), Math.max(0L, this.maxBulkTookMillis.get()), Math.max(0L, this.minBulkTookMillis.get()));
    }
}

