/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.search.vectors.KnnSearchRequestParser;

public class RestKnnSearchAction
extends BaseRestHandler {
    static final String DEPRECATION_MESSAGE = "The kNN search API has been replaced by the `knn` option in the search API.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.GET, "{index}/_knn_search").deprecatedForRemoval(DEPRECATION_MESSAGE, RestApiVersion.V_8).build(), RestHandler.Route.builder(RestRequest.Method.POST, "{index}/_knn_search").deprecatedForRemoval(DEPRECATION_MESSAGE, RestApiVersion.V_8).build());
    }

    @Override
    public String getName() {
        return "knn_search_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RestCancellableNodeClient cancellableNodeClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
        KnnSearchRequestParser parser = KnnSearchRequestParser.parseRestRequest(restRequest);
        SearchRequestBuilder searchRequestBuilder = cancellableNodeClient.prepareSearch(new String[0]);
        parser.toSearchRequest(searchRequestBuilder);
        return channel -> searchRequestBuilder.execute(new RestRefCountedChunkedToXContentListener((RestChannel)channel));
    }
}

