/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class DotExpanderProcessor
extends AbstractProcessor {
    static final String TYPE = "dot_expander";
    private final String path;
    private final String field;
    private final boolean override;

    DotExpanderProcessor(String tag, String description, String path, String field) {
        this(tag, description, path, field, false);
    }

    DotExpanderProcessor(String tag, String description, String path, String field, boolean override) {
        super(tag, description);
        this.path = path;
        this.field = field;
        this.override = override;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Map map;
        Object pathToExpand;
        if (this.path != null) {
            pathToExpand = this.path + "." + this.field;
            map = ingestDocument.getFieldValue(this.path, Map.class);
        } else {
            pathToExpand = this.field;
            map = ingestDocument.getSourceAndMetadata();
        }
        if (this.field.equals("*")) {
            for (String key : new ArrayList(map.keySet())) {
                if (key.indexOf(46) <= 0) continue;
                pathToExpand = this.path != null ? this.path + "." + key : key;
                this.expandDot(ingestDocument, (String)pathToExpand, key, map);
            }
        } else {
            this.expandDot(ingestDocument, (String)pathToExpand, this.field, map);
        }
        return ingestDocument;
    }

    private void expandDot(IngestDocument ingestDocument, String pathToExpand, String fieldName, Map<String, Object> map) {
        if (map.containsKey(fieldName)) {
            if (ingestDocument.hasField(pathToExpand)) {
                Object value = map.remove(fieldName);
                if (this.override) {
                    ingestDocument.setFieldValue(pathToExpand, value);
                } else {
                    ingestDocument.appendFieldValue(pathToExpand, value);
                }
            } else {
                String partialPath;
                int index = pathToExpand.indexOf(46);
                while (index != -1 && ingestDocument.hasField(partialPath = pathToExpand.substring(0, index))) {
                    Object val = ingestDocument.getFieldValue(partialPath, Object.class);
                    if (!(val instanceof Map)) {
                        throw new IllegalArgumentException("cannot expand [" + pathToExpand + "], because [" + partialPath + "] is not an object field, but a value field");
                    }
                    index = pathToExpand.indexOf(46, index + 1);
                }
                Object value = map.remove(fieldName);
                ingestDocument.setFieldValue(pathToExpand, value);
            }
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getPath() {
        return this.path;
    }

    String getField() {
        return this.field;
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String field = ConfigurationUtils.readStringProperty(DotExpanderProcessor.TYPE, tag, config, "field");
            if (!field.contains(".") && !field.equals("*")) {
                throw ConfigurationUtils.newConfigurationException("tag", tag, "field", "field does not contain a dot and is not a wildcard");
            }
            if (field.indexOf(46) == 0 || field.lastIndexOf(46) == field.length() - 1) {
                throw ConfigurationUtils.newConfigurationException("tag", tag, "field", "Field can't start or end with a dot");
            }
            int firstIndex = -1;
            int index = field.indexOf(46);
            while (index != -1) {
                if (index - firstIndex == 1) {
                    throw ConfigurationUtils.newConfigurationException("tag", tag, "field", "No space between dots");
                }
                firstIndex = index;
                index = field.indexOf(46, index + 1);
            }
            String path = ConfigurationUtils.readOptionalStringProperty(DotExpanderProcessor.TYPE, tag, config, "path");
            boolean override = ConfigurationUtils.readBooleanProperty(DotExpanderProcessor.TYPE, tag, config, "override", false);
            return new DotExpanderProcessor(tag, null, path, field, override);
        }
    }
}

