/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;

public class VectorSimilarityFloatValueSource
extends DoubleValuesSource {
    private final String field;
    private final float[] target;
    private final VectorSimilarityFunction vectorSimilarityFunction;

    public VectorSimilarityFloatValueSource(String field, float[] target, VectorSimilarityFunction vectorSimilarityFunction) {
        this.field = field;
        this.target = target;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        LeafReader reader = ctx.reader();
        final FloatVectorValues vectorValues = reader.getFloatVectorValues(this.field);
        final KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return VectorSimilarityFloatValueSource.this.vectorSimilarityFunction.compare(VectorSimilarityFloatValueSource.this.target, vectorValues.vectorValue(iterator.index()));
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= iterator.docID() && iterator.docID() != Integer.MAX_VALUE && iterator.advance(doc) == doc;
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.field, Arrays.hashCode(this.target), this.vectorSimilarityFunction});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorSimilarityFloatValueSource that = (VectorSimilarityFloatValueSource)o;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.target, that.target) && this.vectorSimilarityFunction == that.vectorSimilarityFunction;
    }

    @Override
    public String toString() {
        return "VectorSimilarityFloatValueSource(" + this.field + ", [" + this.target[0] + ",...], " + String.valueOf((Object)this.vectorSimilarityFunction) + ")";
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }
}

