/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.shard.ShardId;

public record DesiredBalance(long lastConvergedIndex, Map<ShardId, ShardAssignment> assignments, Map<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> weightsPerNode, ComputationFinishReason finishReason) {
    public static final DesiredBalance NOT_MASTER = new DesiredBalance(-2L, Map.of());
    public static final DesiredBalance BECOME_MASTER_INITIAL = new DesiredBalance(-1L, Map.of());

    public DesiredBalance(long lastConvergedIndex, Map<ShardId, ShardAssignment> assignments) {
        this(lastConvergedIndex, assignments, Map.of(), ComputationFinishReason.CONVERGED);
    }

    public ShardAssignment getAssignment(ShardId shardId) {
        return this.assignments.get(shardId);
    }

    public static boolean hasChanges(DesiredBalance a, DesiredBalance b) {
        return !Objects.equals(a.assignments, b.assignments);
    }

    public static int shardMovements(DesiredBalance old, DesiredBalance updated) {
        Set<ShardId> intersection = Sets.intersection(old.assignments().keySet(), updated.assignments().keySet());
        int movements = 0;
        for (ShardId shardId : intersection) {
            ShardAssignment updatedAssignment;
            ShardAssignment oldAssignment = old.getAssignment(shardId);
            if (Objects.equals(oldAssignment, updatedAssignment = updated.getAssignment(shardId))) continue;
            movements += DesiredBalance.shardMovements(oldAssignment, updatedAssignment);
        }
        return movements;
    }

    private static int shardMovements(ShardAssignment old, ShardAssignment updated) {
        int movements = Math.min(0, old.assigned() - updated.assigned());
        for (String nodeId : updated.nodeIds()) {
            if (old.nodeIds().contains(nodeId)) continue;
            ++movements;
        }
        assert (movements >= 0) : "Unexpected movement count [" + movements + "] between [" + String.valueOf(old) + "] and [" + String.valueOf(updated) + "]";
        return movements;
    }

    public static String humanReadableDiff(DesiredBalance old, DesiredBalance updated) {
        ShardAssignment updatedAssignment;
        ShardAssignment oldAssignment;
        Set<ShardId> intersection = Sets.intersection(old.assignments().keySet(), updated.assignments().keySet());
        Set<ShardId> diff = Sets.difference(Sets.union(old.assignments().keySet(), updated.assignments().keySet()), intersection);
        String newLine = System.lineSeparator();
        StringBuilder builder = new StringBuilder();
        for (ShardId shardId : intersection) {
            oldAssignment = old.getAssignment(shardId);
            if (Objects.equals(oldAssignment, updatedAssignment = updated.getAssignment(shardId))) continue;
            builder.append(newLine).append(shardId).append(": ").append(oldAssignment).append(" -> ").append(updatedAssignment);
        }
        for (ShardId shardId : diff) {
            oldAssignment = old.getAssignment(shardId);
            updatedAssignment = updated.getAssignment(shardId);
            builder.append(newLine).append(shardId).append(": ").append(oldAssignment).append(" -> ").append(updatedAssignment);
        }
        return builder.append(newLine).toString();
    }

    static enum ComputationFinishReason {
        CONVERGED,
        YIELD_TO_NEW_INPUT,
        STOP_EARLY;

    }
}

