/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RawIndexingDataTransportRequest;

public final class BulkShardRequest
extends ReplicatedWriteRequest<BulkShardRequest>
implements Accountable,
RawIndexingDataTransportRequest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BulkShardRequest.class);
    private final BulkItemRequest[] items;
    private final boolean isSimulated;
    private transient Map<String, InferenceFieldMetadata> inferenceFieldMap = null;

    public BulkShardRequest(StreamInput in) throws IOException {
        super(in);
        this.items = in.readArray(i -> i.readOptionalWriteable(inpt -> new BulkItemRequest(this.shardId, inpt)), BulkItemRequest[]::new);
        this.isSimulated = in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readBoolean() : false;
    }

    public BulkShardRequest(ShardId shardId, WriteRequest.RefreshPolicy refreshPolicy, BulkItemRequest[] items) {
        this(shardId, refreshPolicy, items, false);
    }

    public BulkShardRequest(ShardId shardId, WriteRequest.RefreshPolicy refreshPolicy, BulkItemRequest[] items, boolean isSimulated) {
        super(shardId);
        this.items = items;
        this.setRefreshPolicy(refreshPolicy);
        this.isSimulated = isSimulated;
    }

    public void setInferenceFieldMap(Map<String, InferenceFieldMetadata> fieldInferenceMap) {
        this.inferenceFieldMap = fieldInferenceMap;
    }

    public Map<String, InferenceFieldMetadata> consumeInferenceFieldMap() {
        Map<String, InferenceFieldMetadata> ret = this.inferenceFieldMap;
        this.inferenceFieldMap = null;
        return ret;
    }

    public Map<String, InferenceFieldMetadata> getInferenceFieldMap() {
        return this.inferenceFieldMap;
    }

    public long totalSizeInBytes() {
        long totalSizeInBytes = 0L;
        for (int i = 0; i < this.items.length; ++i) {
            IndexRequest doc;
            DocWriteRequest<?> request = this.items[i].request();
            if (request instanceof IndexRequest) {
                if (((IndexRequest)request).source() == null) continue;
                totalSizeInBytes += (long)((IndexRequest)request).source().length();
                continue;
            }
            if (!(request instanceof UpdateRequest) || (doc = ((UpdateRequest)request).doc()) == null || doc.source() == null) continue;
            totalSizeInBytes += (long)((UpdateRequest)request).doc().source().length();
        }
        return totalSizeInBytes;
    }

    public long maxOperationSizeInBytes() {
        long maxOperationSizeInBytes = 0L;
        for (int i = 0; i < this.items.length; ++i) {
            IndexRequest doc;
            DocWriteRequest<?> request = this.items[i].request();
            if (request instanceof IndexRequest) {
                if (((IndexRequest)request).source() == null) continue;
                maxOperationSizeInBytes = Math.max(maxOperationSizeInBytes, (long)((IndexRequest)request).source().length());
                continue;
            }
            if (!(request instanceof UpdateRequest) || (doc = ((UpdateRequest)request).doc()) == null || doc.source() == null) continue;
            maxOperationSizeInBytes = Math.max(maxOperationSizeInBytes, (long)((UpdateRequest)request).doc().source().length());
        }
        return maxOperationSizeInBytes;
    }

    public BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public String[] indices() {
        HashSet<String> indices = Sets.newHashSetWithExpectedSize(1);
        for (BulkItemRequest item : this.items) {
            if (item == null) continue;
            indices.add(item.index());
        }
        return indices.toArray(new String[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.inferenceFieldMap != null) {
            throw new IllegalStateException("Inference metadata should have been consumed before writing to the stream");
        }
        super.writeTo(out);
        out.writeArray((o, item) -> o.writeOptional(BulkItemRequest.THIN_WRITER, item), this.items);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeBoolean(this.isSimulated);
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("BulkShardRequest [");
        b.append(this.shardId).append("] containing [");
        if (this.items.length > 1) {
            b.append(this.items.length).append("] requests");
        } else {
            b.append(this.items[0].request()).append("]");
        }
        switch (this.getRefreshPolicy()) {
            case IMMEDIATE: {
                b.append(" and a refresh");
                break;
            }
            case WAIT_UNTIL: {
                b.append(" blocking until refresh");
                break;
            }
        }
        if (this.isSimulated) {
            b.append(", simulated");
        }
        return b.toString();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder().append("requests[").append(this.items.length).append("], index").append(this.shardId);
        WriteRequest.RefreshPolicy refreshPolicy = this.getRefreshPolicy();
        if (refreshPolicy == WriteRequest.RefreshPolicy.IMMEDIATE || refreshPolicy == WriteRequest.RefreshPolicy.WAIT_UNTIL) {
            stringBuilder.append(", refresh[").append(refreshPolicy).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    protected BulkShardRequest routedBasedOnClusterVersion(long routedBasedOnClusterVersion) {
        return (BulkShardRequest)super.routedBasedOnClusterVersion(routedBasedOnClusterVersion);
    }

    @Override
    public void onRetry() {
        for (BulkItemRequest item : this.items) {
            if (!(item.request() instanceof ReplicationRequest)) continue;
            ((ReplicationRequest)((Object)item.request())).onRetry();
        }
    }

    @Override
    public long ramBytesUsed() {
        long sum = SHALLOW_SIZE;
        for (BulkItemRequest item : this.items) {
            sum += item.ramBytesUsed();
        }
        return sum;
    }

    public long largestOperationSize() {
        long maxOperationSize = 0L;
        for (BulkItemRequest item : this.items) {
            maxOperationSize = Math.max(maxOperationSize, item.ramBytesUsed());
        }
        return maxOperationSize;
    }

    public boolean isSimulated() {
        return this.isSimulated;
    }
}

