/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutComponentTemplateAction
extends AcknowledgedTransportMasterNodeAction<PutComponentTemplateAction.Request> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPutComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexScopedSettings indexScopedSettings, ProjectResolver projectResolver) {
        super("cluster:admin/component_template/put", transportService, clusterService, threadPool, actionFilters, PutComponentTemplateAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(PutComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    public static ComponentTemplate normalizeComponentTemplate(ComponentTemplate componentTemplate, IndexScopedSettings indexScopedSettings) {
        Template template = componentTemplate.template();
        if (template.settings() != null) {
            Settings.Builder builder = Settings.builder().put(template.settings()).normalizePrefix("index.");
            Settings settings = builder.build();
            indexScopedSettings.validate(settings, true);
            template = Template.builder(template).settings(settings).build();
            componentTemplate = new ComponentTemplate(template, componentTemplate.version(), componentTemplate.metadata(), componentTemplate.deprecated());
        }
        return componentTemplate;
    }

    @Override
    protected void masterOperation(Task task, PutComponentTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ComponentTemplate componentTemplate = TransportPutComponentTemplateAction.normalizeComponentTemplate(request.componentTemplate(), this.indexScopedSettings);
        ProjectId projectId = this.projectResolver.getProjectId();
        this.indexTemplateService.putComponentTemplate(request.cause(), request.create(), request.name(), request.masterNodeTimeout(), componentTemplate, projectId, listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("index_templates");
    }

    @Override
    public Set<String> modifiedKeys(PutComponentTemplateAction.Request request) {
        return Set.of(ReservedComposableIndexTemplateAction.reservedComponentName(request.name()));
    }

    @Override
    protected void validateForReservedState(PutComponentTemplateAction.Request request, ClusterState state) {
        super.validateForReservedState(request, state);
        this.validateForReservedState(this.projectResolver.getProjectMetadata(state).reservedStateMetadata().values(), this.reservedStateHandlerName().get(), this.modifiedKeys(request), request.toString());
    }
}

