/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.tasks;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;

public class PendingClusterTasksResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final List<PendingClusterTask> pendingTasks;

    public PendingClusterTasksResponse(StreamInput in) throws IOException {
        this.pendingTasks = in.readCollectionAsList(PendingClusterTask::new);
    }

    PendingClusterTasksResponse(List<PendingClusterTask> pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public List<PendingClusterTask> pendingTasks() {
        return this.pendingTasks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tasks: (").append(this.pendingTasks.size()).append("):\n");
        for (PendingClusterTask pendingClusterTask : this.pendingTasks) {
            sb.append(pendingClusterTask.getInsertOrder()).append("/").append((Object)pendingClusterTask.getPriority()).append("/").append(pendingClusterTask.getSource()).append("/").append(pendingClusterTask.getTimeInQueue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((builder, p) -> {
            builder.startObject();
            builder.startArray("tasks");
            return builder;
        }), Iterators.map(this.pendingTasks.iterator(), pendingClusterTask -> (builder, p) -> {
            builder.startObject();
            builder.field("insert_order", pendingClusterTask.getInsertOrder());
            builder.field("priority", pendingClusterTask.getPriority());
            builder.field("source", pendingClusterTask.getSource());
            builder.field("executing", pendingClusterTask.isExecuting());
            builder.field("time_in_queue_millis", pendingClusterTask.getTimeInQueueInMillis());
            builder.field("time_in_queue", pendingClusterTask.getTimeInQueue());
            builder.endObject();
            return builder;
        }), Iterators.single((builder, p) -> {
            builder.endArray();
            builder.endObject();
            return builder;
        }));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.pendingTasks);
    }

    static final class Fields {
        static final String TASKS = "tasks";
        static final String EXECUTING = "executing";
        static final String INSERT_ORDER = "insert_order";
        static final String PRIORITY = "priority";
        static final String SOURCE = "source";
        static final String TIME_IN_QUEUE_MILLIS = "time_in_queue_millis";
        static final String TIME_IN_QUEUE = "time_in_queue";

        Fields() {
        }
    }
}

