/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.ml.TransformAuthorization;
import co.elastic.clients.elasticsearch.transform.Latest;
import co.elastic.clients.elasticsearch.transform.Pivot;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Source;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformSummary
implements JsonpSerializable {
    @Nullable
    private final TransformAuthorization authorization;
    @Nullable
    private final Long createTime;
    @Nullable
    private final DateTime createTimeString;
    @Nullable
    private final String description;
    private final Destination dest;
    @Nullable
    private final Time frequency;
    private final String id;
    @Nullable
    private final Latest latest;
    @Nullable
    private final Pivot pivot;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final Settings settings;
    private final Source source;
    @Nullable
    private final Sync sync;
    @Nullable
    private final String version;
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<TransformSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformSummary::setupTransformSummaryDeserializer);

    private TransformSummary(Builder builder) {
        this.authorization = builder.authorization;
        this.createTime = builder.createTime;
        this.createTimeString = builder.createTimeString;
        this.description = builder.description;
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.frequency = builder.frequency;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.latest = builder.latest;
        this.pivot = builder.pivot;
        this.retentionPolicy = builder.retentionPolicy;
        this.settings = builder.settings;
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.sync = builder.sync;
        this.version = builder.version;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static TransformSummary of(Function<Builder, ObjectBuilder<TransformSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TransformAuthorization authorization() {
        return this.authorization;
    }

    @Nullable
    public final Long createTime() {
        return this.createTime;
    }

    @Nullable
    public final DateTime createTimeString() {
        return this.createTimeString;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final Destination dest() {
        return this.dest;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Latest latest() {
        return this.latest;
    }

    @Nullable
    public final Pivot pivot() {
        return this.pivot;
    }

    @Nullable
    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public final Settings settings() {
        return this.settings;
    }

    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Sync sync() {
        return this.sync;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.authorization != null) {
            generator.writeKey("authorization");
            this.authorization.serialize(generator, mapper);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime);
        }
        if (this.createTimeString != null) {
            generator.writeKey("create_time_string");
            this.createTimeString.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
        if (this.latest != null) {
            generator.writeKey("latest");
            this.latest.serialize(generator, mapper);
        }
        if (this.pivot != null) {
            generator.writeKey("pivot");
            this.pivot.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTransformSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::authorization, TransformAuthorization._DESERIALIZER, "authorization");
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time");
        op.add(Builder::createTimeString, DateTime._DESERIALIZER, "create_time_string");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::latest, Latest._DESERIALIZER, "latest");
        op.add(Builder::pivot, Pivot._DESERIALIZER, "pivot");
        op.add(Builder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy");
        op.add(Builder::settings, Settings._DESERIALIZER, "settings");
        op.add(Builder::source, Source._DESERIALIZER, "source");
        op.add(Builder::sync, Sync._DESERIALIZER, "sync");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformSummary> {
        @Nullable
        private TransformAuthorization authorization;
        @Nullable
        private Long createTime;
        @Nullable
        private DateTime createTimeString;
        @Nullable
        private String description;
        private Destination dest;
        @Nullable
        private Time frequency;
        private String id;
        @Nullable
        private Latest latest;
        @Nullable
        private Pivot pivot;
        @Nullable
        private RetentionPolicy retentionPolicy;
        @Nullable
        private Settings settings;
        private Source source;
        @Nullable
        private Sync sync;
        @Nullable
        private String version;
        @Nullable
        private Map<String, JsonData> meta;

        public final Builder authorization(@Nullable TransformAuthorization value) {
            this.authorization = value;
            return this;
        }

        public final Builder authorization(Function<TransformAuthorization.Builder, ObjectBuilder<TransformAuthorization>> fn) {
            return this.authorization(fn.apply(new TransformAuthorization.Builder()).build());
        }

        public final Builder createTime(@Nullable Long value) {
            this.createTime = value;
            return this;
        }

        public final Builder createTimeString(@Nullable DateTime value) {
            this.createTimeString = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder latest(@Nullable Latest value) {
            this.latest = value;
            return this;
        }

        public final Builder latest(Function<Latest.Builder, ObjectBuilder<Latest>> fn) {
            return this.latest(fn.apply(new Latest.Builder()).build());
        }

        public final Builder pivot(@Nullable Pivot value) {
            this.pivot = value;
            return this;
        }

        public final Builder pivot(Function<Pivot.Builder, ObjectBuilder<Pivot>> fn) {
            return this.pivot(fn.apply(new Pivot.Builder()).build());
        }

        public final Builder retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this;
        }

        public final Builder retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public final Builder retentionPolicy(RetentionPolicyVariant value) {
            this.retentionPolicy = value._toRetentionPolicy();
            return this;
        }

        public final Builder settings(@Nullable Settings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public final Builder source(Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder sync(@Nullable Sync value) {
            this.sync = value;
            return this;
        }

        public final Builder sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public final Builder sync(SyncVariant value) {
            this.sync = value._toSync();
            return this;
        }

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformSummary build() {
            this._checkSingleUse();
            return new TransformSummary(this);
        }
    }
}

