/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.AggregateOutput;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModel;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Ensemble
implements JsonpSerializable {
    @Nullable
    private final AggregateOutput aggregateOutput;
    private final List<String> classificationLabels;
    private final List<String> featureNames;
    @Nullable
    private final String targetType;
    private final List<TrainedModel> trainedModels;
    public static final JsonpDeserializer<Ensemble> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ensemble::setupEnsembleDeserializer);

    private Ensemble(Builder builder) {
        this.aggregateOutput = builder.aggregateOutput;
        this.classificationLabels = ApiTypeHelper.unmodifiable(builder.classificationLabels);
        this.featureNames = ApiTypeHelper.unmodifiable(builder.featureNames);
        this.targetType = builder.targetType;
        this.trainedModels = ApiTypeHelper.unmodifiableRequired(builder.trainedModels, (Object)this, "trainedModels");
    }

    public static Ensemble of(Function<Builder, ObjectBuilder<Ensemble>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AggregateOutput aggregateOutput() {
        return this.aggregateOutput;
    }

    public final List<String> classificationLabels() {
        return this.classificationLabels;
    }

    public final List<String> featureNames() {
        return this.featureNames;
    }

    @Nullable
    public final String targetType() {
        return this.targetType;
    }

    public final List<TrainedModel> trainedModels() {
        return this.trainedModels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggregateOutput != null) {
            generator.writeKey("aggregate_output");
            this.aggregateOutput.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.classificationLabels)) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String string : this.classificationLabels) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.featureNames)) {
            generator.writeKey("feature_names");
            generator.writeStartArray();
            for (String string : this.featureNames) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.targetType != null) {
            generator.writeKey("target_type");
            generator.write(this.targetType);
        }
        if (ApiTypeHelper.isDefined(this.trainedModels)) {
            generator.writeKey("trained_models");
            generator.writeStartArray();
            for (TrainedModel trainedModel : this.trainedModels) {
                trainedModel.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEnsembleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregateOutput, AggregateOutput._DESERIALIZER, "aggregate_output");
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels");
        op.add(Builder::featureNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_names");
        op.add(Builder::targetType, JsonpDeserializer.stringDeserializer(), "target_type");
        op.add(Builder::trainedModels, JsonpDeserializer.arrayDeserializer(TrainedModel._DESERIALIZER), "trained_models");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Ensemble> {
        @Nullable
        private AggregateOutput aggregateOutput;
        @Nullable
        private List<String> classificationLabels;
        @Nullable
        private List<String> featureNames;
        @Nullable
        private String targetType;
        private List<TrainedModel> trainedModels;

        public final Builder aggregateOutput(@Nullable AggregateOutput value) {
            this.aggregateOutput = value;
            return this;
        }

        public final Builder aggregateOutput(Function<AggregateOutput.Builder, ObjectBuilder<AggregateOutput>> fn) {
            return this.aggregateOutput(fn.apply(new AggregateOutput.Builder()).build());
        }

        public final Builder classificationLabels(List<String> list) {
            this.classificationLabels = Builder._listAddAll(this.classificationLabels, list);
            return this;
        }

        public final Builder classificationLabels(String value, String ... values) {
            this.classificationLabels = Builder._listAdd(this.classificationLabels, value, values);
            return this;
        }

        public final Builder featureNames(List<String> list) {
            this.featureNames = Builder._listAddAll(this.featureNames, list);
            return this;
        }

        public final Builder featureNames(String value, String ... values) {
            this.featureNames = Builder._listAdd(this.featureNames, value, values);
            return this;
        }

        public final Builder targetType(@Nullable String value) {
            this.targetType = value;
            return this;
        }

        public final Builder trainedModels(List<TrainedModel> list) {
            this.trainedModels = Builder._listAddAll(this.trainedModels, list);
            return this;
        }

        public final Builder trainedModels(TrainedModel value, TrainedModel ... values) {
            this.trainedModels = Builder._listAdd(this.trainedModels, value, values);
            return this;
        }

        public final Builder trainedModels(Function<TrainedModel.Builder, ObjectBuilder<TrainedModel>> fn) {
            return this.trainedModels(fn.apply(new TrainedModel.Builder()).build(), new TrainedModel[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ensemble build() {
            this._checkSingleUse();
            return new Ensemble(this);
        }
    }
}

