/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.License;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.InferenceToXContentCompressor;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelDefinition;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedTrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedTrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.FeatureImportanceBaseline;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.Hyperparameters;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.TotalFeatureImportance;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TrainedModelConfig
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_model_config";
    public static final int CURRENT_DEFINITION_COMPRESSION_VERSION = 1;
    public static final String DECOMPRESS_DEFINITION = "decompress_definition";
    public static final String TOTAL_FEATURE_IMPORTANCE = "total_feature_importance";
    public static final String FEATURE_IMPORTANCE_BASELINE = "feature_importance_baseline";
    public static final String HYPERPARAMETERS = "hyperparameters";
    public static final String MODEL_ALIASES = "model_aliases";
    public static final String DEFINITION_STATUS = "definition_status";
    private static final String ESTIMATED_HEAP_MEMORY_USAGE_HUMAN = "estimated_heap_memory_usage";
    private static final String MODEL_SIZE_HUMAN = "model_size";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField MODEL_TYPE = new ParseField("model_type", new String[0]);
    public static final ParseField CREATED_BY = new ParseField("created_by", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField COMPRESSED_DEFINITION = new ParseField("compressed_definition", new String[0]);
    public static final ParseField TAGS = new ParseField("tags", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField INPUT = new ParseField("input", new String[0]);
    public static final ParseField MODEL_SIZE_BYTES = new ParseField("model_size_bytes", new String[0]);
    public static final ParseField MODEL_SIZE_BYTES_WITH_DEPRECATION = new ParseField("model_size_bytes", "estimated_heap_memory_usage_bytes");
    public static final ParseField DEPRECATED_ESTIMATED_HEAP_MEMORY_USAGE_BYTES = new ParseField("estimated_heap_memory_usage_bytes", new String[0]);
    public static final ParseField ESTIMATED_OPERATIONS = new ParseField("estimated_operations", new String[0]);
    public static final ParseField LICENSE_LEVEL = new ParseField("license_level", new String[0]);
    public static final ParseField DEFAULT_FIELD_MAP = new ParseField("default_field_map", new String[0]);
    public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
    public static final ParseField LOCATION = new ParseField("location", new String[0]);
    public static final ParseField MODEL_PACKAGE = new ParseField("model_package", new String[0]);
    public static final ParseField PREFIX_STRINGS = new ParseField("prefix_strings", new String[0]);
    public static final ParseField PER_DEPLOYMENT_MEMORY_BYTES = new ParseField("per_deployment_memory_bytes", new String[0]);
    public static final ParseField PER_ALLOCATION_MEMORY_BYTES = new ParseField("per_allocation_memory_bytes", new String[0]);
    public static final ParseField PLATFORM_ARCHITECTURE = new ParseField("platform_architecture", new String[0]);
    public static final TransportVersion VERSION_3RD_PARTY_CONFIG_ADDED = TransportVersions.V_8_0_0;
    public static final TransportVersion VERSION_ALLOCATION_MEMORY_ADDED = TransportVersions.V_8_11_X;
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelConfig.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelConfig.createParser(false);
    private final String modelId;
    private final String createdBy;
    private final MlConfigVersion version;
    private final String description;
    private final Instant createTime;
    private final TrainedModelType modelType;
    private final List<String> tags;
    private final Map<String, Object> metadata;
    private final TrainedModelInput input;
    private final long modelSize;
    private final long estimatedOperations;
    private final License.OperationMode licenseLevel;
    private final Map<String, String> defaultFieldMap;
    private final InferenceConfig inferenceConfig;
    private final LazyModelDefinition definition;
    private final TrainedModelLocation location;
    private final ModelPackageConfig modelPackageConfig;
    private Boolean fullDefinition;
    private String platformArchitecture;
    private TrainedModelPrefixStrings prefixStrings;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME, ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setModelId, MODEL_ID);
        parser.declareString(Builder::setModelType, MODEL_TYPE);
        parser.declareString(Builder::setCreatedBy, CREATED_BY);
        parser.declareString(Builder::setVersion, VERSION);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareField(Builder::setCreateTime, (p, c) -> TimeUtils.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareStringArray(Builder::setTags, TAGS);
        parser.declareObject(Builder::setMetadata, (p, c) -> p.map(), METADATA);
        parser.declareString((trainedModelConfig, s) -> {}, InferenceIndexConstants.DOC_TYPE);
        parser.declareObject(Builder::setInput, (p, c) -> TrainedModelInput.fromXContent(p, ignoreUnknownFields), INPUT);
        if (ignoreUnknownFields) {
            parser.declareLong(Builder::setModelSize, DEPRECATED_ESTIMATED_HEAP_MEMORY_USAGE_BYTES);
            parser.declareLong(Builder::setModelSize, MODEL_SIZE_BYTES);
        } else {
            parser.declareLong(Builder::setModelSize, MODEL_SIZE_BYTES_WITH_DEPRECATION);
        }
        parser.declareLong(Builder::setEstimatedOperations, ESTIMATED_OPERATIONS);
        parser.declareObject(Builder::setLazyDefinition, (p, c) -> TrainedModelDefinition.fromXContent(p, ignoreUnknownFields), DEFINITION);
        parser.declareString(Builder::setLazyDefinition, COMPRESSED_DEFINITION);
        parser.declareString(Builder::setLicenseLevel, LICENSE_LEVEL);
        parser.declareObject(Builder::setDefaultFieldMap, (p, c) -> p.mapStrings(), DEFAULT_FIELD_MAP);
        parser.declareNamedObject(Builder::setInferenceConfig, (p, c, n) -> ignoreUnknownFields ? (InferenceConfig)p.namedObject(LenientlyParsedInferenceConfig.class, n, null) : (InferenceConfig)p.namedObject(StrictlyParsedInferenceConfig.class, n, null), INFERENCE_CONFIG);
        parser.declareNamedObject(Builder::setLocation, (p, c, n) -> ignoreUnknownFields ? (TrainedModelLocation)p.namedObject(LenientlyParsedTrainedModelLocation.class, n, null) : (TrainedModelLocation)p.namedObject(StrictlyParsedTrainedModelLocation.class, n, null), LOCATION);
        parser.declareObject(Builder::setModelPackageConfig, (p, c) -> ignoreUnknownFields ? ModelPackageConfig.fromXContentLenient(p) : ModelPackageConfig.fromXContentStrict(p), MODEL_PACKAGE);
        parser.declareString(Builder::setPlatformArchitecture, PLATFORM_ARCHITECTURE);
        parser.declareObject(Builder::setPrefixStrings, (p, c) -> TrainedModelPrefixStrings.fromXContent(p, ignoreUnknownFields), PREFIX_STRINGS);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.parse(parser, null) : STRICT_PARSER.parse(parser, null);
    }

    TrainedModelConfig(String modelId, TrainedModelType modelType, String createdBy, MlConfigVersion version, String description, Instant createTime, LazyModelDefinition definition, List<String> tags, Map<String, Object> metadata, TrainedModelInput input, Long modelSize, Long estimatedOperations, String licenseLevel, Map<String, String> defaultFieldMap, InferenceConfig inferenceConfig, TrainedModelLocation location, ModelPackageConfig modelPackageConfig, String platformArchitecture, TrainedModelPrefixStrings prefixStrings) {
        this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        this.modelType = modelType;
        this.createdBy = ExceptionsHelper.requireNonNull(createdBy, CREATED_BY);
        this.version = ExceptionsHelper.requireNonNull(version, VERSION);
        this.createTime = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(createTime, CREATE_TIME).toEpochMilli());
        this.definition = definition;
        this.description = description;
        this.tags = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(tags, TAGS));
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.input = ExceptionsHelper.requireNonNull(TrainedModelConfig.handleDefaultInput(input, inferenceConfig, modelType), INPUT);
        if (ExceptionsHelper.requireNonNull(modelSize, MODEL_SIZE_BYTES) < 0L) {
            throw new IllegalArgumentException("[" + MODEL_SIZE_BYTES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.modelSize = modelSize;
        if (ExceptionsHelper.requireNonNull(estimatedOperations, ESTIMATED_OPERATIONS) < 0L) {
            throw new IllegalArgumentException("[" + ESTIMATED_OPERATIONS.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.estimatedOperations = estimatedOperations;
        this.licenseLevel = License.OperationMode.parse(ExceptionsHelper.requireNonNull(licenseLevel, LICENSE_LEVEL));
        assert (this.licenseLevel.equals((Object)License.OperationMode.PLATINUM) || this.licenseLevel.equals((Object)License.OperationMode.BASIC)) : "[" + LICENSE_LEVEL.getPreferredName() + "] only [platinum] or [basic] is supported";
        this.defaultFieldMap = defaultFieldMap == null ? null : Collections.unmodifiableMap(defaultFieldMap);
        this.inferenceConfig = inferenceConfig;
        this.location = location;
        this.modelPackageConfig = modelPackageConfig;
        this.platformArchitecture = platformArchitecture;
        this.prefixStrings = prefixStrings;
    }

    private static TrainedModelInput handleDefaultInput(TrainedModelInput input, InferenceConfig inferenceConfig, TrainedModelType modelType) {
        return input == null && inferenceConfig != null ? inferenceConfig.getDefaultInput(modelType) : input;
    }

    public TrainedModelConfig(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.createdBy = in.readString();
        this.version = MlConfigVersion.readVersion(in);
        this.description = in.readOptionalString();
        this.createTime = in.readInstant();
        this.definition = in.readOptionalWriteable(LazyModelDefinition::fromStreamInput);
        this.tags = in.readCollectionAsImmutableList(StreamInput::readString);
        this.metadata = in.readGenericMap();
        this.input = new TrainedModelInput(in);
        this.modelSize = in.readVLong();
        this.estimatedOperations = in.readVLong();
        this.licenseLevel = License.OperationMode.parse(in.readString());
        this.defaultFieldMap = in.readBoolean() ? in.readImmutableMap(StreamInput::readString) : null;
        this.inferenceConfig = in.readOptionalNamedWriteable(InferenceConfig.class);
        if (in.getTransportVersion().onOrAfter(VERSION_3RD_PARTY_CONFIG_ADDED)) {
            this.modelType = in.readOptionalEnum(TrainedModelType.class);
            this.location = in.readOptionalNamedWriteable(TrainedModelLocation.class);
        } else {
            this.modelType = null;
            this.location = null;
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            this.modelPackageConfig = in.readOptionalWriteable(ModelPackageConfig::new);
            this.fullDefinition = in.readOptionalBoolean();
        } else {
            this.modelPackageConfig = null;
            this.fullDefinition = null;
        }
        this.platformArchitecture = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readOptionalString() : null;
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.prefixStrings = in.readOptionalWriteable(TrainedModelPrefixStrings::new);
        }
    }

    public boolean isPackagedModel() {
        return this.modelId.startsWith(".");
    }

    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public TrainedModelType getModelType() {
        return this.modelType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public MlConfigVersion getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getDefaultFieldMap() {
        return this.defaultFieldMap;
    }

    @Nullable
    public InferenceConfig getInferenceConfig() {
        return this.inferenceConfig;
    }

    @Nullable
    public BytesReference getCompressedDefinition() throws IOException {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getCompressedDefinition();
    }

    public BytesReference getCompressedDefinitionIfSet() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getCompressedDefinitionIfSet();
    }

    public ModelPackageConfig getModelPackageConfig() {
        return this.modelPackageConfig;
    }

    public void clearCompressed() {
        this.definition.compressedRepresentation = null;
    }

    public TrainedModelConfig ensureParsedDefinition(NamedXContentRegistry xContentRegistry) throws IOException {
        if (this.definition == null) {
            return null;
        }
        this.definition.ensureParsedDefinition(xContentRegistry);
        return this;
    }

    public TrainedModelConfig ensureParsedDefinitionUnsafe(NamedXContentRegistry xContentRegistry) throws IOException {
        if (this.definition == null) {
            return null;
        }
        this.definition.ensureParsedDefinitionUnsafe(xContentRegistry);
        return this;
    }

    @Nullable
    public TrainedModelDefinition getModelDefinition() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.parsedDefinition;
    }

    @Nullable
    public TrainedModelLocation getLocation() {
        return this.location;
    }

    public TrainedModelInput getInput() {
        return this.input;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getModelSize() {
        return this.modelSize;
    }

    public long getEstimatedOperations() {
        return this.estimatedOperations;
    }

    public License.OperationMode getLicenseLevel() {
        return this.licenseLevel;
    }

    public boolean isAllocateOnly() {
        return Optional.ofNullable(this.inferenceConfig).map(InferenceConfig::isAllocateOnly).orElse(false);
    }

    public void setFullDefinition(boolean fullDefinition) {
        this.fullDefinition = fullDefinition;
    }

    public long getPerDeploymentMemoryBytes() {
        return this.metadata != null && this.metadata.containsKey(PER_DEPLOYMENT_MEMORY_BYTES.getPreferredName()) ? ((Number)this.metadata.get(PER_DEPLOYMENT_MEMORY_BYTES.getPreferredName())).longValue() : 0L;
    }

    public long getPerAllocationMemoryBytes() {
        return this.metadata != null && this.metadata.containsKey(PER_ALLOCATION_MEMORY_BYTES.getPreferredName()) ? ((Number)this.metadata.get(PER_ALLOCATION_MEMORY_BYTES.getPreferredName())).longValue() : 0L;
    }

    public String getPlatformArchitecture() {
        return this.platformArchitecture;
    }

    public TrainedModelPrefixStrings getPrefixStrings() {
        return this.prefixStrings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.createdBy);
        MlConfigVersion.writeVersion(this.version, out);
        out.writeOptionalString(this.description);
        out.writeInstant(this.createTime);
        out.writeOptionalWriteable(this.definition);
        out.writeStringCollection(this.tags);
        out.writeGenericMap(this.metadata);
        this.input.writeTo(out);
        out.writeVLong(this.modelSize);
        out.writeVLong(this.estimatedOperations);
        out.writeString(this.licenseLevel.description());
        if (this.defaultFieldMap != null) {
            out.writeBoolean(true);
            out.writeMap(this.defaultFieldMap, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalNamedWriteable(this.inferenceConfig);
        if (out.getTransportVersion().onOrAfter(VERSION_3RD_PARTY_CONFIG_ADDED)) {
            out.writeOptionalEnum(this.modelType);
            out.writeOptionalNamedWriteable(this.location);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeOptionalWriteable(this.modelPackageConfig);
            out.writeOptionalBoolean(this.fullDefinition);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            out.writeOptionalString(this.platformArchitecture);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalWriteable(this.prefixStrings);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        if (this.modelType != null) {
            builder.field(MODEL_TYPE.getPreferredName(), this.modelType.toString());
        }
        if (this.modelPackageConfig != null) {
            builder.field(MODEL_PACKAGE.getPreferredName(), this.modelPackageConfig);
        }
        if (this.platformArchitecture != null) {
            builder.field(PLATFORM_ARCHITECTURE.getPreferredName(), this.platformArchitecture);
        }
        if (!params.paramAsBoolean("exclude_generated", false)) {
            builder.field(CREATED_BY.getPreferredName(), this.createdBy);
            builder.field(VERSION.getPreferredName(), this.version.toString());
            builder.timestampFieldsFromUnixEpochMillis(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
            builder.humanReadableField(MODEL_SIZE_BYTES.getPreferredName(), MODEL_SIZE_HUMAN, ByteSizeValue.ofBytes(this.modelSize));
            builder.field(ESTIMATED_OPERATIONS.getPreferredName(), this.estimatedOperations);
            builder.field(LICENSE_LEVEL.getPreferredName(), this.licenseLevel.description());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (!params.paramAsBoolean("for_internal_storage", false) && this.definition != null) {
            if (params.paramAsBoolean(DECOMPRESS_DEFINITION, false)) {
                builder.field(DEFINITION.getPreferredName(), this.definition);
            } else {
                builder.field(COMPRESSED_DEFINITION.getPreferredName(), this.definition.getBase64CompressedDefinition());
            }
        }
        builder.field(TAGS.getPreferredName(), (Collection<String>)this.tags);
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        }
        builder.field(INPUT.getPreferredName(), this.input);
        if (this.defaultFieldMap != null && !this.defaultFieldMap.isEmpty()) {
            builder.field(DEFAULT_FIELD_MAP.getPreferredName(), this.defaultFieldMap);
        }
        if (this.inferenceConfig != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, INFERENCE_CONFIG.getPreferredName(), this.inferenceConfig);
        }
        if (this.location != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, LOCATION.getPreferredName(), this.location);
        }
        if (this.prefixStrings != null) {
            builder.field(PREFIX_STRINGS.getPreferredName(), this.prefixStrings);
        }
        if (params.paramAsBoolean(DEFINITION_STATUS, false) && this.fullDefinition != null) {
            builder.field("fully_defined", this.fullDefinition);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return org.elasticsearch.common.Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelConfig that = (TrainedModelConfig)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals((Object)this.modelType, (Object)that.modelType) && Objects.equals(this.modelPackageConfig, that.modelPackageConfig) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.definition, that.definition) && Objects.equals(this.tags, that.tags) && Objects.equals(this.input, that.input) && Objects.equals(this.modelSize, that.modelSize) && Objects.equals(this.estimatedOperations, that.estimatedOperations) && Objects.equals((Object)this.licenseLevel, (Object)that.licenseLevel) && Objects.equals(this.defaultFieldMap, that.defaultFieldMap) && Objects.equals(this.inferenceConfig, that.inferenceConfig) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.location, that.location) && Objects.equals(this.platformArchitecture, that.platformArchitecture) && Objects.equals(this.prefixStrings, that.prefixStrings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelId, this.modelType, this.modelPackageConfig, this.createdBy, this.version, this.createTime, this.definition, this.description, this.tags, this.metadata, this.modelSize, this.estimatedOperations, this.input, this.licenseLevel, this.inferenceConfig, this.defaultFieldMap, this.location, this.platformArchitecture, this.prefixStrings});
    }

    public static class Builder {
        private String modelId;
        private TrainedModelType modelType;
        private String createdBy;
        private MlConfigVersion version;
        private String description;
        private Instant createTime;
        private List<String> tags = Collections.emptyList();
        private Map<String, Object> metadata;
        private TrainedModelInput input;
        private Long modelSize;
        private Long estimatedOperations;
        private LazyModelDefinition definition;
        private String licenseLevel;
        private Map<String, String> defaultFieldMap;
        private InferenceConfig inferenceConfig;
        private TrainedModelLocation location;
        private ModelPackageConfig modelPackageConfig;
        private String platformArchitecture;
        private TrainedModelPrefixStrings prefixStrings;

        public Builder() {
        }

        public Builder(TrainedModelConfig config) {
            this.modelId = config.getModelId();
            this.modelType = config.modelType;
            this.createdBy = config.getCreatedBy();
            this.version = config.getVersion();
            this.createTime = config.getCreateTime();
            this.definition = config.definition == null ? null : new LazyModelDefinition(config.definition);
            this.description = config.getDescription();
            this.tags = config.getTags();
            this.metadata = config.getMetadata() == null ? null : new HashMap<String, Object>(config.getMetadata());
            this.input = config.getInput();
            this.estimatedOperations = config.estimatedOperations;
            this.modelSize = config.modelSize;
            this.licenseLevel = config.licenseLevel.description();
            this.defaultFieldMap = config.defaultFieldMap == null ? null : new HashMap<String, String>(config.defaultFieldMap);
            this.inferenceConfig = config.inferenceConfig;
            this.location = config.location;
            this.modelPackageConfig = config.modelPackageConfig;
            this.platformArchitecture = config.platformArchitecture;
            this.prefixStrings = config.prefixStrings;
        }

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public TrainedModelType getModelType() {
            return this.modelType;
        }

        private Builder setModelType(String modelType) {
            this.modelType = TrainedModelType.fromString(modelType);
            return this;
        }

        public Builder setModelType(TrainedModelType modelType) {
            this.modelType = modelType;
            return this;
        }

        public String getModelId() {
            return this.modelId;
        }

        public Builder setModelPackageConfig(ModelPackageConfig modelPackageConfig) {
            this.modelPackageConfig = modelPackageConfig;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public MlConfigVersion getVersion() {
            return this.version;
        }

        public Builder setVersion(MlConfigVersion version) {
            this.version = version;
            return this;
        }

        private Builder setVersion(String version) {
            return this.setVersion(MlConfigVersion.fromString(version));
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setTags(List<String> tags) {
            this.tags = ExceptionsHelper.requireNonNull(tags, TAGS);
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setFeatureImportance(List<TotalFeatureImportance> totalFeatureImportance) {
            if (totalFeatureImportance == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.TOTAL_FEATURE_IMPORTANCE, totalFeatureImportance.stream().map(TotalFeatureImportance::asMap).collect(Collectors.toList()));
        }

        public Builder setBaselineFeatureImportance(FeatureImportanceBaseline featureImportanceBaseline) {
            if (featureImportanceBaseline == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.FEATURE_IMPORTANCE_BASELINE, featureImportanceBaseline.asMap());
        }

        public Builder setHyperparameters(List<Hyperparameters> hyperparameters) {
            if (hyperparameters == null) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.HYPERPARAMETERS, hyperparameters.stream().map(Hyperparameters::asMap).collect(Collectors.toList()));
        }

        public Builder setPlatformArchitecture(String platformArchitecture) {
            this.platformArchitecture = platformArchitecture;
            return this;
        }

        public Builder setPrefixStrings(TrainedModelPrefixStrings prefixStrings) {
            this.prefixStrings = prefixStrings;
            return this;
        }

        public Builder setModelAliases(Set<String> modelAliases) {
            if (modelAliases == null || modelAliases.isEmpty()) {
                return this;
            }
            return this.addToMetadata(TrainedModelConfig.MODEL_ALIASES, modelAliases.stream().sorted().collect(Collectors.toList()));
        }

        private Builder addToMetadata(String fieldName, Object value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Object>();
            }
            this.metadata.put(fieldName, value);
            return this;
        }

        public Builder setParsedDefinition(TrainedModelDefinition.Builder definitionRef) {
            if (definitionRef == null) {
                return this;
            }
            this.definition = LazyModelDefinition.fromParsedDefinition(definitionRef.build());
            return this;
        }

        public Builder setDefinitionFromBytes(BytesReference definitionRef) {
            if (definitionRef == null) {
                return this;
            }
            this.definition = LazyModelDefinition.fromCompressedData(definitionRef);
            return this;
        }

        public Builder clearDefinition() {
            this.definition = null;
            return this;
        }

        private Builder setLazyDefinition(TrainedModelDefinition.Builder parsedTrainedModel) {
            if (parsedTrainedModel == null) {
                return this;
            }
            if (this.definition != null) {
                throw new IllegalArgumentException(Strings.format("both [%s] and [%s] cannot be set.", COMPRESSED_DEFINITION.getPreferredName(), DEFINITION.getPreferredName()));
            }
            this.definition = LazyModelDefinition.fromParsedDefinition(parsedTrainedModel.build());
            return this;
        }

        private Builder setLazyDefinition(String compressedString) {
            if (compressedString == null) {
                return this;
            }
            if (this.definition != null) {
                throw new IllegalArgumentException(Strings.format("both [%s] and [%s] cannot be set.", COMPRESSED_DEFINITION.getPreferredName(), DEFINITION.getPreferredName()));
            }
            this.definition = LazyModelDefinition.fromBase64String(compressedString);
            return this;
        }

        public Builder setLocation(TrainedModelLocation location) {
            this.location = location;
            return this;
        }

        public Builder setInput(TrainedModelInput input) {
            this.input = input;
            return this;
        }

        public Builder setModelSize(long modelSize) {
            this.modelSize = modelSize;
            return this;
        }

        public Builder setEstimatedOperations(long estimatedOperations) {
            this.estimatedOperations = estimatedOperations;
            return this;
        }

        public Builder setLicenseLevel(String licenseLevel) {
            this.licenseLevel = licenseLevel;
            return this;
        }

        public Builder setDefaultFieldMap(Map<String, String> defaultFieldMap) {
            this.defaultFieldMap = defaultFieldMap;
            return this;
        }

        public Builder setInferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public Builder validate() {
            return this.validate(false);
        }

        public Builder validate(boolean forCreation) {
            List badTags;
            boolean packagedModel;
            ActionRequestValidationException validationException = null;
            boolean bl = packagedModel = this.modelId != null && this.modelId.startsWith(".");
            if (this.modelId == null) {
                validationException = ValidateActions.addValidationError("[" + MODEL_ID.getPreferredName() + "] must not be null.", validationException);
            }
            if (!packagedModel) {
                if (this.definition != null && this.location != null) {
                    validationException = ValidateActions.addValidationError("[" + DEFINITION.getPreferredName() + "] and [" + LOCATION.getPreferredName() + "] are both defined but only one can be used.", validationException);
                }
                if (this.definition == null && this.modelType == null) {
                    validationException = ValidateActions.addValidationError("[" + MODEL_TYPE.getPreferredName() + "] must be set if [" + DEFINITION.getPreferredName() + "] is not defined.", validationException);
                }
                if (this.inferenceConfig == null && forCreation) {
                    validationException = ValidateActions.addValidationError("[" + INFERENCE_CONFIG.getPreferredName() + "] must not be null.", validationException);
                }
            }
            if (this.modelId != null) {
                if (packagedModel) {
                    String idToValidate = this.modelId.substring(1);
                    if (idToValidate.endsWith("_SNAPSHOT")) {
                        idToValidate = idToValidate.substring(0, idToValidate.length() - 9);
                    }
                    if (!MlStrings.isValidId(idToValidate)) {
                        validationException = ValidateActions.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' is not a valid model package id", MODEL_ID.getPreferredName(), this.modelId), validationException);
                    }
                } else if (!MlStrings.isValidId(this.modelId)) {
                    validationException = ValidateActions.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", MODEL_ID.getPreferredName(), this.modelId), validationException);
                }
            }
            if (this.modelId != null && !MlStrings.hasValidLengthForId(this.modelId)) {
                validationException = ValidateActions.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' cannot contain more than {2} characters.", MODEL_ID.getPreferredName(), this.modelId, 64), validationException);
            }
            if (!(badTags = this.tags.stream().filter(tag -> !(MlStrings.isValidId(tag) && MlStrings.hasValidLengthForId(tag))).collect(Collectors.toList())).isEmpty()) {
                validationException = ValidateActions.addValidationError(Messages.getMessage("Invalid tags {0}; must only can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores, must start and end with alphanumeric, and must be less than {1} characters.", badTags, 64), validationException);
            }
            for (String tag2 : this.tags) {
                if (!tag2.equals(this.modelId)) continue;
                validationException = ValidateActions.addValidationError("none of the tags must equal the model_id", validationException);
                break;
            }
            if (this.inferenceConfig != null) {
                validationException = this.inferenceConfig.validateTrainedModelInput(this.input, forCreation, validationException);
            }
            if (forCreation) {
                validationException = Builder.checkIllegalSetting(this.version, VERSION.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.createdBy, CREATED_BY.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.createTime, CREATE_TIME.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.licenseLevel, LICENSE_LEVEL.getPreferredName(), validationException);
                validationException = Builder.checkIllegalSetting(this.location, LOCATION.getPreferredName(), validationException);
                if (this.metadata != null) {
                    validationException = Builder.checkIllegalSetting(this.metadata.get(TrainedModelConfig.TOTAL_FEATURE_IMPORTANCE), METADATA.getPreferredName() + ".total_feature_importance", validationException);
                    validationException = Builder.checkIllegalSetting(this.metadata.get(TrainedModelConfig.MODEL_ALIASES), METADATA.getPreferredName() + ".model_aliases", validationException);
                }
                validationException = Builder.checkIllegalSetting(this.modelPackageConfig, MODEL_PACKAGE.getPreferredName(), validationException);
            }
            if (validationException != null) {
                throw validationException;
            }
            return this;
        }

        public Builder validateNoPackageOverrides() {
            ActionRequestValidationException validationException = null;
            validationException = Builder.checkIllegalPackagedModelSetting(this.description, DESCRIPTION.getPreferredName(), validationException);
            validationException = Builder.checkIllegalPackagedModelSetting(this.definition, DEFINITION.getPreferredName(), validationException);
            validationException = Builder.checkIllegalPackagedModelSetting((Object)this.modelType, MODEL_TYPE.getPreferredName(), validationException);
            validationException = Builder.checkIllegalPackagedModelSetting(this.metadata, METADATA.getPreferredName(), validationException);
            if (this.modelSize != null && this.modelSize > 0L) {
                validationException = Builder.checkIllegalPackagedModelSetting(this.modelSize, MODEL_SIZE_BYTES.getPreferredName(), validationException);
            }
            validationException = Builder.checkIllegalPackagedModelSetting(this.inferenceConfig, INFERENCE_CONFIG.getPreferredName(), validationException);
            if (this.tags != null && !this.tags.isEmpty()) {
                validationException = ValidateActions.addValidationError("illegal to set [tags] at inference model creation for packaged model", validationException);
            }
            if (validationException != null) {
                throw validationException;
            }
            return this;
        }

        private static ActionRequestValidationException checkIllegalSetting(Object value, String setting, ActionRequestValidationException validationException) {
            if (value != null) {
                return ValidateActions.addValidationError("illegal to set [" + setting + "] at inference model creation", validationException);
            }
            return validationException;
        }

        private static ActionRequestValidationException checkIllegalPackagedModelSetting(Object value, String setting, ActionRequestValidationException validationException) {
            if (value != null) {
                return ValidateActions.addValidationError("illegal to set [" + setting + "] at inference model creation for packaged model", validationException);
            }
            return validationException;
        }

        public TrainedModelConfig build() {
            return new TrainedModelConfig(this.modelId, this.modelType, this.createdBy == null ? "user" : this.createdBy, this.version == null ? MlConfigVersion.CURRENT : this.version, this.description, this.createTime == null ? Instant.now() : this.createTime, this.definition, this.tags, this.metadata, this.input, this.modelSize == null ? 0L : this.modelSize, this.estimatedOperations == null ? 0L : this.estimatedOperations, this.licenseLevel == null ? License.OperationMode.PLATINUM.description() : this.licenseLevel, this.defaultFieldMap, this.inferenceConfig, this.location, this.modelPackageConfig, this.platformArchitecture, this.prefixStrings);
        }
    }

    static class LazyModelDefinition
    implements ToXContentObject,
    Writeable {
        private BytesReference compressedRepresentation;
        private TrainedModelDefinition parsedDefinition;

        public static LazyModelDefinition fromParsedDefinition(TrainedModelDefinition definition) {
            return new LazyModelDefinition(null, definition);
        }

        public static LazyModelDefinition fromCompressedData(BytesReference compressed) {
            return new LazyModelDefinition(compressed, null);
        }

        public static LazyModelDefinition fromBase64String(String base64String) {
            byte[] decodedBytes = Base64.getDecoder().decode(base64String);
            return new LazyModelDefinition(new BytesArray(decodedBytes), null);
        }

        public static LazyModelDefinition fromStreamInput(StreamInput input) throws IOException {
            if (input.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
                return new LazyModelDefinition(input.readBytesReference(), null);
            }
            return LazyModelDefinition.fromBase64String(input.readString());
        }

        private LazyModelDefinition(LazyModelDefinition definition) {
            if (definition != null) {
                this.compressedRepresentation = definition.compressedRepresentation;
                this.parsedDefinition = definition.parsedDefinition;
            }
        }

        private LazyModelDefinition(BytesReference compressedRepresentation, TrainedModelDefinition trainedModelDefinition) {
            if (compressedRepresentation == null && trainedModelDefinition == null) {
                throw new IllegalArgumentException("unexpected null model definition");
            }
            this.compressedRepresentation = compressedRepresentation;
            this.parsedDefinition = trainedModelDefinition;
        }

        private BytesReference getCompressedDefinition() throws IOException {
            if (this.compressedRepresentation == null) {
                this.compressedRepresentation = InferenceToXContentCompressor.deflate(this.parsedDefinition);
            }
            return this.compressedRepresentation;
        }

        private BytesReference getCompressedDefinitionIfSet() {
            return this.compressedRepresentation;
        }

        private String getBase64CompressedDefinition() throws IOException {
            BytesReference compressedDef = this.getCompressedDefinition();
            ByteBuffer bb = Base64.getEncoder().encode(ByteBuffer.wrap(compressedDef.array(), compressedDef.arrayOffset(), compressedDef.length()));
            return new String(bb.array(), StandardCharsets.UTF_8);
        }

        private void ensureParsedDefinition(NamedXContentRegistry xContentRegistry) throws IOException {
            if (this.parsedDefinition == null) {
                this.parsedDefinition = InferenceToXContentCompressor.inflate(this.compressedRepresentation, parser -> TrainedModelDefinition.fromXContent(parser, true).build(), xContentRegistry);
            }
        }

        private void ensureParsedDefinitionUnsafe(NamedXContentRegistry xContentRegistry) throws IOException {
            if (this.parsedDefinition == null) {
                this.parsedDefinition = InferenceToXContentCompressor.inflateUnsafe(this.compressedRepresentation, parser -> TrainedModelDefinition.fromXContent(parser, true).build(), xContentRegistry);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
                out.writeBytesReference(this.getCompressedDefinition());
            } else {
                out.writeString(this.getBase64CompressedDefinition());
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.parsedDefinition != null) {
                return this.parsedDefinition.toXContent(builder, params);
            }
            Map<String, Object> map = InferenceToXContentCompressor.inflateToMap(this.compressedRepresentation);
            return builder.map(map);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LazyModelDefinition that = (LazyModelDefinition)o;
            return Objects.equals(this.compressedRepresentation, that.compressedRepresentation) && Objects.equals(this.parsedDefinition, that.parsedDefinition);
        }

        public int hashCode() {
            return Objects.hash(this.compressedRepresentation, this.parsedDefinition);
        }
    }
}

