/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;

public class GetDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final GetDataFrameAnalyticsAction INSTANCE = new GetDataFrameAnalyticsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/data_frame/analytics/get";

    private GetDataFrameAnalyticsAction() {
        super(NAME);
    }

    public static class Response
    extends AbstractGetResourcesResponse<DataFrameAnalyticsConfig> {
        public static final ParseField RESULTS_FIELD = new ParseField("data_frame_analytics", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<DataFrameAnalyticsConfig> analytics) {
            super(analytics);
        }

        @Override
        protected Writeable.Reader<DataFrameAnalyticsConfig> getReader() {
            return DataFrameAnalyticsConfig::new;
        }
    }

    public static final class Request
    extends AbstractGetResourcesRequest {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);

        public Request() {
            this.setAllowNoResources(true);
        }

        public Request(String id) {
            this.setResourceId(id);
            this.setAllowNoResources(true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getResourceIdField() {
            return DataFrameAnalyticsConfig.ID.getPreferredName();
        }

        @Override
        public String getCancelableTaskDescription() {
            return Strings.format("get_data_frame_analytics[%s]", this.getResourceId());
        }
    }
}

