/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.RolloverStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateRolloverLifecycleDateStep;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForActiveShardsStep;
import org.elasticsearch.xpack.core.ilm.WaitForRolloverReadyStep;

public class RolloverAction
implements LifecycleAction {
    public static final String NAME = "rollover";
    public static final String INDEXING_COMPLETE_STEP_NAME = "set-indexing-complete";
    public static final String LIFECYCLE_ROLLOVER_ALIAS = "index.lifecycle.rollover_alias";
    public static final Setting<String> LIFECYCLE_ROLLOVER_ALIAS_SETTING = Setting.simpleString("index.lifecycle.rollover_alias", Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final Settings INDEXING_COMPLETE = Settings.builder().put("index.lifecycle.indexing_complete", true).build();
    private final RolloverConditions conditions;

    public static RolloverAction parse(XContentParser parser) throws IOException {
        return new RolloverAction(RolloverConditions.fromXContent(parser));
    }

    public RolloverAction(RolloverConditions conditions) {
        if (!conditions.hasMaxConditions()) {
            throw new IllegalArgumentException("At least one max_* rollover condition must be set.");
        }
        this.conditions = conditions;
    }

    public RolloverAction(@Nullable ByteSizeValue maxSize, @Nullable ByteSizeValue maxPrimaryShardSize, @Nullable TimeValue maxAge, @Nullable Long maxDocs, @Nullable Long maxPrimaryShardDocs, @Nullable ByteSizeValue minSize, @Nullable ByteSizeValue minPrimaryShardSize, @Nullable TimeValue minAge, @Nullable Long minDocs, @Nullable Long minPrimaryShardDocs) {
        this(RolloverConditions.newBuilder().addMaxIndexSizeCondition(maxSize).addMaxPrimaryShardSizeCondition(maxPrimaryShardSize).addMaxIndexAgeCondition(maxAge).addMaxIndexDocsCondition(maxDocs).addMaxPrimaryShardDocsCondition(maxPrimaryShardDocs).addMinIndexSizeCondition(minSize).addMinPrimaryShardSizeCondition(minPrimaryShardSize).addMinIndexAgeCondition(minAge).addMinIndexDocsCondition(minDocs).addMinPrimaryShardDocsCondition(minPrimaryShardDocs).build());
    }

    public static RolloverAction read(StreamInput in) throws IOException {
        RolloverConditions.Builder builder = RolloverConditions.newBuilder();
        builder.addMaxIndexSizeCondition(in.readOptionalWriteable(ByteSizeValue::readFrom));
        builder.addMaxPrimaryShardSizeCondition(in.readOptionalWriteable(ByteSizeValue::readFrom));
        builder.addMaxIndexAgeCondition(in.readOptionalTimeValue());
        builder.addMaxIndexDocsCondition(in.readOptionalVLong());
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            builder.addMaxPrimaryShardDocsCondition(in.readOptionalVLong());
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            builder.addMinIndexSizeCondition(in.readOptionalWriteable(ByteSizeValue::readFrom));
            builder.addMinPrimaryShardSizeCondition(in.readOptionalWriteable(ByteSizeValue::readFrom));
            builder.addMinIndexAgeCondition(in.readOptionalTimeValue());
            builder.addMinIndexDocsCondition(in.readOptionalVLong());
            builder.addMinPrimaryShardDocsCondition(in.readOptionalVLong());
        }
        return new RolloverAction(builder.build());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.conditions.getMaxSize());
        out.writeOptionalWriteable(this.conditions.getMaxPrimaryShardSize());
        out.writeOptionalTimeValue(this.conditions.getMaxAge());
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            out.writeOptionalVLong(this.conditions.getMaxDocs());
            out.writeOptionalVLong(this.conditions.getMaxPrimaryShardDocs());
        } else if (this.conditions.getMaxDocs() == null) {
            out.writeOptionalVLong(this.conditions.getMaxPrimaryShardDocs());
        } else {
            out.writeOptionalVLong(this.conditions.getMaxDocs());
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeOptionalWriteable(this.conditions.getMinSize());
            out.writeOptionalWriteable(this.conditions.getMinPrimaryShardSize());
            out.writeOptionalTimeValue(this.conditions.getMinAge());
            out.writeOptionalVLong(this.conditions.getMinDocs());
            out.writeOptionalVLong(this.conditions.getMinPrimaryShardDocs());
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public RolloverConditions getConditions() {
        return this.conditions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.conditions.toXContent(builder, params);
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey waitForRolloverReadyStepKey = new Step.StepKey(phase, NAME, "check-rollover-ready");
        Step.StepKey rolloverStepKey = new Step.StepKey(phase, NAME, "attempt-rollover");
        Step.StepKey waitForActiveShardsKey = new Step.StepKey(phase, NAME, "wait-for-active-shards");
        Step.StepKey updateDateStepKey = new Step.StepKey(phase, NAME, "update-rollover-lifecycle-date");
        Step.StepKey setIndexingCompleteStepKey = new Step.StepKey(phase, NAME, INDEXING_COMPLETE_STEP_NAME);
        WaitForRolloverReadyStep waitForRolloverReadyStep = new WaitForRolloverReadyStep(waitForRolloverReadyStepKey, rolloverStepKey, client, this.conditions);
        RolloverStep rolloverStep = new RolloverStep(rolloverStepKey, waitForActiveShardsKey, client);
        WaitForActiveShardsStep waitForActiveShardsStep = new WaitForActiveShardsStep(waitForActiveShardsKey, updateDateStepKey);
        UpdateRolloverLifecycleDateStep updateDateStep = new UpdateRolloverLifecycleDateStep(updateDateStepKey, setIndexingCompleteStepKey, System::currentTimeMillis);
        UpdateSettingsStep setIndexingCompleteStep = new UpdateSettingsStep(setIndexingCompleteStepKey, nextStepKey, client, INDEXING_COMPLETE);
        return List.of(waitForRolloverReadyStep, rolloverStep, waitForActiveShardsStep, updateDateStep, setIndexingCompleteStep);
    }

    public int hashCode() {
        return Objects.hash(this.conditions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverAction other = (RolloverAction)obj;
        return Objects.equals(this.conditions, other.conditions);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

