/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.vectors.AbstractIVFKnnVectorQuery;

public class IVFKnnFloatVectorQuery
extends AbstractIVFKnnVectorQuery {
    private final float[] query;

    public IVFKnnFloatVectorQuery(String field, float[] query, int k, int numCands, Query filter, int nProbe) {
        super(field, nProbe, k, numCands, filter);
        this.query = query;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append(":").append(this.field).append("[").append(this.query[0]).append(",...]").append("[").append(this.k).append("]");
        if (this.filter != null) {
            buffer.append("[").append(this.filter).append("]");
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        IVFKnnFloatVectorQuery that = (IVFKnnFloatVectorQuery)o;
        return Arrays.equals(this.query, that.query);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.query);
        return result;
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, this.searchStrategy, context);
        if (knnCollector == null) {
            return NO_RESULTS;
        }
        LeafReader reader = context.reader();
        FloatVectorValues floatVectorValues = reader.getFloatVectorValues(this.field);
        if (floatVectorValues == null) {
            FloatVectorValues.checkField(reader, this.field);
            return NO_RESULTS;
        }
        if (Math.min(knnCollector.k(), floatVectorValues.size()) == 0) {
            return NO_RESULTS;
        }
        reader.searchNearestVectors(this.field, this.query, knnCollector, acceptDocs);
        TopDocs results = knnCollector.topDocs();
        return results != null ? results : NO_RESULTS;
    }
}

