/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class UpdatePersistentTaskStatusAction {
    public static final ActionType<PersistentTaskResponse> INSTANCE = new ActionType("cluster:admin/persistent/update_status");

    private UpdatePersistentTaskStatusAction() {
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;
        private final ProjectResolver projectResolver;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, ProjectResolver projectResolver) {
            super(INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, PersistentTaskResponse::new, threadPool.executor("management"));
            this.persistentTasksClusterService = persistentTasksClusterService;
            this.projectResolver = projectResolver;
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Task ignoredTask, Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            ProjectId projectIdHint = PersistentTasksClusterService.resolveProjectIdHint(this.projectResolver);
            this.persistentTasksClusterService.updatePersistentTaskState(projectIdHint, request.taskId, request.allocationId, request.state, listener.map(PersistentTaskResponse::new));
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String taskId;
        private final long allocationId;
        private final PersistentTaskState state;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.state = in.readOptionalNamedWriteable(PersistentTaskState.class);
        }

        public Request(TimeValue masterNodeTimeout, String taskId, long allocationId, PersistentTaskState state) {
            super(masterNodeTimeout);
            this.taskId = taskId;
            this.allocationId = allocationId;
            this.state = state;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public long getAllocationId() {
            return this.allocationId;
        }

        public PersistentTaskState getState() {
            return this.state;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeOptionalNamedWriteable(this.state);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id must be specified", validationException);
            }
            if (this.allocationId == -1L) {
                validationException = ValidateActions.addValidationError("allocationId must be specified", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.state, request.state);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.state);
        }
    }
}

