/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.node.ReportingService;

public class JvmService
implements ReportingService<JvmInfo> {
    private static final Logger logger = LogManager.getLogger(JvmService.class);
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final SingleObjectCache<JvmStats> jvmStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.jvm.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public JvmService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.jvmStatsCache = new JvmStatsCache(this, refreshInterval, JvmStats.jvmStats());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public JvmInfo info() {
        return this.jvmInfo;
    }

    public JvmStats stats() {
        return this.jvmStatsCache.getOrRefresh();
    }

    private class JvmStatsCache
    extends SingleObjectCache<JvmStats> {
        JvmStatsCache(JvmService jvmService, TimeValue interval, JvmStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected JvmStats refresh() {
            return JvmStats.jvmStats();
        }
    }
}

