/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

class EnterpriseGeoIpTaskState
implements PersistentTaskState,
VersionedNamedWriteable {
    private static final ParseField DATABASES = new ParseField("databases", new String[0]);
    static final EnterpriseGeoIpTaskState EMPTY = new EnterpriseGeoIpTaskState(Map.of());
    private static final ConstructingObjectParser<EnterpriseGeoIpTaskState, Void> PARSER = new ConstructingObjectParser("geoip-downloader", true, args -> {
        List databases = (List)args[0];
        return new EnterpriseGeoIpTaskState(databases.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
    });
    private final Map<String, GeoIpTaskState.Metadata> databases;

    public static EnterpriseGeoIpTaskState fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    EnterpriseGeoIpTaskState(Map<String, GeoIpTaskState.Metadata> databases) {
        this.databases = Map.copyOf(databases);
    }

    EnterpriseGeoIpTaskState(StreamInput input) throws IOException {
        this.databases = input.readImmutableMap(in -> new GeoIpTaskState.Metadata(in.readLong(), in.readVInt(), in.readVInt(), in.readString(), in.readLong(), in.readOptionalString()));
    }

    public EnterpriseGeoIpTaskState put(String name, GeoIpTaskState.Metadata metadata) {
        HashMap<String, GeoIpTaskState.Metadata> newDatabases = new HashMap<String, GeoIpTaskState.Metadata>(this.databases);
        newDatabases.put(name, metadata);
        return new EnterpriseGeoIpTaskState(newDatabases);
    }

    public EnterpriseGeoIpTaskState remove(String name) {
        HashMap<String, GeoIpTaskState.Metadata> newDatabases = new HashMap<String, GeoIpTaskState.Metadata>(this.databases);
        newDatabases.remove(name);
        return new EnterpriseGeoIpTaskState(newDatabases);
    }

    public Map<String, GeoIpTaskState.Metadata> getDatabases() {
        return this.databases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseGeoIpTaskState that = (EnterpriseGeoIpTaskState)o;
        return this.databases.equals(that.databases);
    }

    public int hashCode() {
        return Objects.hash(this.databases);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("databases");
        for (Map.Entry<String, GeoIpTaskState.Metadata> e : this.databases.entrySet()) {
            builder.field(e.getKey(), e.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return "enterprise-geoip-downloader";
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.databases, (o, v) -> {
            o.writeLong(v.lastUpdate());
            o.writeVInt(v.firstChunk());
            o.writeVInt(v.lastChunk());
            o.writeString(v.md5());
            o.writeLong(v.lastCheck());
            o.writeOptionalString(v.sha256());
        });
    }

    @Nullable
    static EnterpriseGeoIpTaskState getEnterpriseGeoIpTaskState(ClusterState state) {
        PersistentTasksCustomMetadata.PersistentTask task = PersistentTasksCustomMetadata.getTaskWithId(state.projectState(ProjectId.DEFAULT).metadata(), "enterprise-geoip-downloader");
        return task == null ? null : (EnterpriseGeoIpTaskState)task.getState();
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> Tuple.tuple(name, GeoIpTaskState.Metadata.fromXContent(p)), DATABASES);
    }
}

