/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;

public final class GroupedActionListener<T>
extends DelegatingActionListener<T, Collection<T>> {
    private final CountDown countDown;
    private final AtomicInteger pos = new AtomicInteger();
    private final AtomicArray<T> results;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public GroupedActionListener(int groupSize, ActionListener<Collection<T>> delegate) {
        super(delegate);
        if (groupSize <= 0) {
            assert (false) : "illegal group size [" + groupSize + "]";
            throw new IllegalArgumentException("groupSize must be greater than 0 but was " + groupSize);
        }
        this.results = new AtomicArray(groupSize);
        this.countDown = new CountDown(groupSize);
    }

    @Override
    public void onResponse(T element) {
        this.results.setOnce(this.pos.incrementAndGet() - 1, element);
        if (this.countDown.countDown()) {
            if (this.failure.get() != null) {
                super.onFailure(this.failure.get());
            } else {
                List<T> collect = this.results.asList();
                this.delegate.onResponse(Collections.unmodifiableList(collect));
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        Exception firstException = this.failure.compareAndExchange(null, e);
        if (firstException != null && firstException != e) {
            firstException.addSuppressed(e);
        }
        if (this.countDown.countDown()) {
            super.onFailure(this.failure.get());
        }
    }
}

