/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ValidateQueryResponse
extends BroadcastResponse {
    public static final String VALID_FIELD = "valid";
    public static final String EXPLANATIONS_FIELD = "explanations";
    private final boolean valid;
    private final List<QueryExplanation> queryExplanations;

    ValidateQueryResponse(boolean valid, List<QueryExplanation> queryExplanations, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.valid = valid;
        this.queryExplanations = queryExplanations == null ? Collections.emptyList() : queryExplanations;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends QueryExplanation> getQueryExplanation() {
        return this.queryExplanations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeCollection(this.queryExplanations);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALID_FIELD, this.isValid());
        if (this.getQueryExplanation() != null && !this.getQueryExplanation().isEmpty()) {
            builder.startArray(EXPLANATIONS_FIELD);
            for (QueryExplanation queryExplanation : this.getQueryExplanation()) {
                builder.startObject();
                queryExplanation.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }
}

