/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.forcemerge;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ForceMergeRequest
extends BroadcastRequest<ForceMergeRequest> {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean shouldStoreResult;
    private static final TransportVersion FORCE_MERGE_UUID_SIMPLE_VERSION = TransportVersions.V_8_0_0;
    private final String forceMergeUUID;

    public ForceMergeRequest(String ... indices) {
        super(indices);
        this.forceMergeUUID = UUIDs.randomBase64UUID();
    }

    public ForceMergeRequest(StreamInput in) throws IOException {
        super(in);
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getTransportVersion().onOrAfter(FORCE_MERGE_UUID_SIMPLE_VERSION)) {
            this.forceMergeUUID = in.readString();
        } else {
            this.forceMergeUUID = in.readOptionalString();
            assert (this.forceMergeUUID != null) : "optional was just used as a BwC measure";
        }
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public ForceMergeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public ForceMergeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public String forceMergeUUID() {
        return this.forceMergeUUID;
    }

    public boolean flush() {
        return this.flush;
    }

    public ForceMergeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    public ForceMergeRequest setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
        return this;
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    @Override
    public String getDescription() {
        return "Force-merge indices " + Arrays.toString(this.indices()) + ", maxSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getTransportVersion().onOrAfter(FORCE_MERGE_UUID_SIMPLE_VERSION)) {
            out.writeString(this.forceMergeUUID);
        } else {
            out.writeOptionalString(this.forceMergeUUID);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationError = super.validate();
        if (this.onlyExpungeDeletes && this.maxNumSegments != -1) {
            validationError = ValidateActions.addValidationError("cannot set only_expunge_deletes and max_num_segments at the same time, those two parameters are mutually exclusive", validationError);
        }
        return validationError;
    }

    @Override
    public String toString() {
        return "ForceMergeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + "}";
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
    }
}

