/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.transport.http.TransportHttpClient;
import javax.annotation.Nullable;

public class ElasticsearchException
extends RuntimeException {
    private final ErrorResponse response;
    private final String endpointId;
    @Nullable
    private final TransportHttpClient.Response httpResponse;

    public ElasticsearchException(String endpointId, ErrorResponse response, @Nullable TransportHttpClient.Response httpResponse) {
        super("[" + endpointId + "] failed: [" + response.error().type() + "] " + response.error().reason());
        this.response = response;
        this.endpointId = endpointId;
        this.httpResponse = httpResponse;
    }

    public ElasticsearchException(String endpointId, ErrorResponse response) {
        this(endpointId, response, null);
    }

    public String endpointId() {
        return this.endpointId;
    }

    public ErrorResponse response() {
        return this.response;
    }

    public ErrorCause error() {
        return this.response.error();
    }

    public int status() {
        return this.response.status();
    }

    @Nullable
    public TransportHttpClient.Response httpResponse() {
        return this.httpResponse;
    }
}

