"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexName = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _validate_index_name = require("../../../../utils/validate_index_name");
var _i18n_string = require("../../../../../common/i18n_string");
var _use_connector = require("../../../hooks/api/use_connector");
var _use_kibana = require("../../../hooks/use_kibana");
var _api_key_panel = require("./api_key_panel");
var _connector_index_name_form = require("./connector_index_name_form");
var _sync_scheduled_callout = require("./sync_scheduled_callout");
var _doc_links = require("../../../../../common/doc_links");
var _common = require("../../../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIndexName = ({
  connector,
  isDisabled
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const [showSyncCallOut, setShowSyncCallOut] = (0, _react.useState)(false);
  const {
    data,
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async ({
      inputName,
      sync
    }) => {
      setShowSyncCallOut(false);
      if (inputName && inputName !== connector.index_name) {
        const body = {
          index_name: inputName
        };
        await http.post(`/internal/serverless_search/connectors/${connector.id}/index_name`, {
          body: JSON.stringify(body)
        });
      }
      if (sync) {
        await http.post(`/internal/serverless_search/connectors/${connector.id}/sync`);
        setShowSyncCallOut(true);
      }
      return inputName;
    },
    onSuccess: () => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  const [newIndexName, setNewIndexname] = (0, _react.useState)(connector.index_name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameTitle', {
    defaultMessage: 'Link index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameDescription', {
    defaultMessage: 'Pick an index where your documents will be synced, or create a new one for this connector.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_index_name_form.ConnectorIndexNameForm, {
    isDisabled: isDisabled,
    indexName: newIndexName || '',
    onChange: name => setNewIndexname(name)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.preprocessData.title', {
    defaultMessage: 'Preprocess your data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.config.preprocessData.description",
    defaultMessage: "Use ingest pipelines to preprocess data before indexing into Elasticsearch. Note that self-managed connectors use the {clientIngestionPipeline} pipeline for preprocessing.",
    values: {
      clientIngestionPipeline: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _common.DEFAULT_INGESTION_PIPELINE)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "serverlessSearchConnectorIndexNameLearnMoreLink",
    href: _doc_links.docLinks.pipelines,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.preprocessDataTitle.learnMore', {
    defaultMessage: 'Learn More'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_api_key_panel.ApiKeyPanel, {
    connector: connector
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexNameButton",
    color: "primary",
    isDisabled: !(0, _validate_index_name.isValidIndexName)(newIndexName) || isDisabled,
    isLoading: isLoading,
    onClick: () => mutate({
      inputName: newIndexName,
      sync: false
    })
  }, _i18n_string.SAVE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexNameSaveAndSyncButton",
    color: "primary",
    disabled: !((0, _validate_index_name.isValidIndexName)(newIndexName) && [_searchConnectors.ConnectorStatus.CONFIGURED, _searchConnectors.ConnectorStatus.CONNECTED].includes(connector.status)) || isDisabled,
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate({
      inputName: newIndexName,
      sync: true
    })
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.saveSyncLabel', {
    defaultMessage: 'Save and sync'
  }))))), showSyncCallOut && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_scheduled_callout.SyncScheduledCallOut, null)));
};
exports.ConnectorIndexName = ConnectorIndexName;