"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStringArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Types the EmptyStringArray as:
 *   - A value that can be undefined, or null (which will be turned into an empty array)
 *   - A comma separated string that can turn into an array by splitting on it
 *   - Example input converted to output: undefined -> []
 *   - Example input converted to output: null -> []
 *   - Example input converted to output: "a,b,c" -> ["a", "b", "c"]
 */
const EmptyStringArray = exports.EmptyStringArray = new t.Type('EmptyStringArray', t.array(t.string).is, (input, context) => {
  if (input == null) {
    return t.success([]);
  } else if (typeof input === 'string' && input.trim() !== '') {
    const arrayValues = input.trim().split(',').map(value => value.trim());
    const emptyValueFound = arrayValues.some(value => value === '');
    if (emptyValueFound) {
      return t.failure(input, context);
    } else {
      return t.success(arrayValues);
    }
  } else {
    return t.failure(input, context);
  }
}, String);