"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProductFeatures = exports.getSecurityAiSocProductTier = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _cases_product_features_config = require("./cases_product_features_config");
var _security_product_features_config = require("./security_product_features_config");
var _assistant_product_features_config = require("./assistant_product_features_config");
var _attack_discovery_product_features_config = require("./attack_discovery_product_features_config");
var _timeline_product_features_config = require("./timeline_product_features_config");
var _notes_product_features_config = require("./notes_product_features_config");
var _siem_migrations_product_features_config = require("./siem_migrations_product_features_config");
var _enable_rule_actions = require("../rules/enable_rule_actions");
var _product = require("../../common/product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerProductFeatures = (pluginsSetup, enabledProductFeatureKeys, config) => {
  var _pluginsSetup$automat;
  // securitySolutionEss plugin should always be disabled when securitySolutionServerless is enabled.
  // This check is an additional layer of security to prevent double registrations when
  // `plugins.forceEnableAllPlugins` flag is enabled. Should never happen in real scenarios.
  const shouldRegister = pluginsSetup.securitySolutionEss == null;
  if (!shouldRegister) {
    return;
  }

  // register product features for the main security solution product features service
  pluginsSetup.securitySolution.setProductFeaturesConfigurator({
    security: (0, _security_product_features_config.getSecurityProductFeaturesConfigurator)(enabledProductFeatureKeys, config.experimentalFeatures),
    cases: (0, _cases_product_features_config.getCasesProductFeaturesConfigurator)(enabledProductFeatureKeys),
    securityAssistant: (0, _assistant_product_features_config.getSecurityAssistantProductFeaturesConfigurator)(enabledProductFeatureKeys),
    attackDiscovery: (0, _attack_discovery_product_features_config.getAttackDiscoveryProductFeaturesConfigurator)(enabledProductFeatureKeys),
    timeline: (0, _timeline_product_features_config.getTimelineProductFeaturesConfigurator)(enabledProductFeatureKeys),
    notes: (0, _notes_product_features_config.getNotesProductFeaturesConfigurator)(enabledProductFeatureKeys),
    siemMigrations: (0, _siem_migrations_product_features_config.getSiemMigrationsProductFeaturesConfigurator)(enabledProductFeatureKeys)
  });

  // enable rule actions based on the enabled product features
  (0, _enable_rule_actions.enableRuleActions)({
    actions: pluginsSetup.actions,
    productFeatureKeys: enabledProductFeatureKeys
  });

  // set availability for the automatic import plugin based on the product features
  (_pluginsSetup$automat = pluginsSetup.automaticImport) === null || _pluginsSetup$automat === void 0 ? void 0 : _pluginsSetup$automat.setIsAvailable(enabledProductFeatureKeys.includes(_keys.ProductFeatureKey.automaticImport));
};

/**
 * Get the product tier from the security/ai_soc product type in the config. This is used to determine if AI features
 * are available in the given configuration.
 */
exports.registerProductFeatures = registerProductFeatures;
const getSecurityAiSocProductTier = (config, logger) => {
  const securityProductType = config.productTypes.find(productType => productType.product_line === _product.ProductLine.security);
  const ai4SocProductType = config.productTypes.find(productType => productType.product_line === _product.ProductLine.aiSoc);
  const tier = securityProductType ? securityProductType.product_tier : ai4SocProductType ? ai4SocProductType.product_tier : 'none';
  if (tier === 'none') {
    logger.error(`Failed to fetch security/aiSoc product tier, config: ${JSON.stringify(config)}`);
  }
  return tier;
};
exports.getSecurityAiSocProductTier = getSecurityAiSocProductTier;