"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFixQueryErrorsNode = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFixQueryErrorsNode = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async state => {
    var _response$match$, _response$match;
    const rule = state.elastic_rule;
    const prompt = await _prompts.RESOLVE_ESQL_ERRORS_TEMPLATE.format({
      esql_errors: state.validation_errors.esql_errors,
      esql_query: rule.query
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const esqlQuery = (_response$match$ = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    rule.query = esqlQuery;
    return {
      elastic_rule: rule
    };
  };
};
exports.getFixQueryErrorsNode = getFixQueryErrorsNode;