"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegedUserParserTransform = void 0;
var _stream = require("stream");
var _Either = require("fp-ts/Either");
var _parse_privileged_user_monitoring_csv_row = require("../../../../../common/entity_analytics/privileged_user_monitoring/parse_privileged_user_monitoring_csv_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transform stream that processes rows of a CSV file containing privileged user data.
 * It parses each row, extracting the username and returning it in a structured format.
 * @param {number} initialRowIndex - The starting index for the rows, defaults to 1, since CSV file are not zero indexed.
 */
const privilegedUserParserTransform = (initialRowIndex = 1) => {
  let index = initialRowIndex;
  return new _stream.Transform({
    objectMode: true,
    transform(row, _encoding, callback) {
      const result = (0, _parse_privileged_user_monitoring_csv_row.parseMonitoredPrivilegedUserCsvRow)(row);
      const formattedResult = (0, _Either.isRight)(result) ? (0, _Either.right)({
        username: result.right.username,
        label: result.right.label ? {
          field: 'label',
          value: result.right.label,
          source: 'csv'
        } : undefined,
        index
      }) : (0, _Either.left)({
        index,
        message: result.left,
        username: null
      }); // The username could not be found in the row

      index++;
      callback(null, formattedResult);
    }
  });
};
exports.privilegedUserParserTransform = privilegedUserParserTransform;