"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMlSignals = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _machine_learning = require("../../../machine_learning");
var _logged_requests = require("../utils/logged_requests");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMlSignals = async ({
  ml,
  request,
  savedObjectsClient,
  jobIds,
  anomalyThreshold,
  from,
  to,
  maxSignals,
  exceptionFilter,
  isLoggedRequestsEnabled
}) => {
  var _dateMath$parse$value, _dateMath$parse, _dateMath$parse$value2, _dateMath$parse2;
  const loggedRequests = [];
  const {
    mlAnomalySearch
  } = ml.mlSystemProvider(request, savedObjectsClient);
  const params = {
    jobIds,
    threshold: anomalyThreshold,
    earliestMs: (_dateMath$parse$value = (_dateMath$parse = _datemath.default.parse(from)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.valueOf()) !== null && _dateMath$parse$value !== void 0 ? _dateMath$parse$value : 0,
    latestMs: (_dateMath$parse$value2 = (_dateMath$parse2 = _datemath.default.parse(to)) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.valueOf()) !== null && _dateMath$parse$value2 !== void 0 ? _dateMath$parse$value2 : 0,
    maxRecords: maxSignals,
    exceptionFilter
  };
  const anomalyResults = await (0, _machine_learning.getAnomalies)(params, mlAnomalySearch);
  if (isLoggedRequestsEnabled) {
    const searchQuery = (0, _machine_learning.buildAnomalyQuery)(params);
    searchQuery.index = '.ml-anomalies-*';
    loggedRequests.push({
      request: (0, _logged_requests.logSearchRequest)(searchQuery),
      description: i18n.ML_SEARCH_ANOMALIES_DESCRIPTION,
      duration: anomalyResults.took,
      request_type: 'findAnomalies'
    });
  }
  return {
    anomalyResults,
    ...(isLoggedRequestsEnabled ? {
      loggedRequests
    } : {})
  };
};
exports.findMlSignals = findMlSignals;