"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeRuleHealthAggregationResult = exports.getRuleHealthAggregation = void 0;
var f = _interopRequireWildcard(require("../../../event_log/event_log_fields"));
var _rule_execution_stats = require("./rule_execution_stats");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleHealthAggregation = granularity => {
  // Let's say we want to calculate rule execution statistics over some date interval, where:
  //   - the whole interval is one week (7 days)
  //   - the interval's granularity is one day
  // This means we will be calculating the same rule execution stats:
  //   - One time over the whole week.
  //   - Seven times over a day, per each day in the week.
  return {
    // And so this function creates several aggs that will be calculated for the whole interval.
    ...(0, _rule_execution_stats.getRuleExecutionStatsAggregation)('whole-interval'),
    // And this one creates a histogram, where for each bucket we will calculate the same aggs.
    // The histogram's "calendar_interval" is equal to the granularity parameter.
    ...getRuleExecutionStatsHistoryAggregation(granularity)
  };
};
exports.getRuleHealthAggregation = getRuleHealthAggregation;
const getRuleExecutionStatsHistoryAggregation = granularity => {
  return {
    statsHistory: {
      date_histogram: {
        field: f.TIMESTAMP,
        calendar_interval: granularity
      },
      aggs: (0, _rule_execution_stats.getRuleExecutionStatsAggregation)('histogram')
    }
  };
};
const normalizeRuleHealthAggregationResult = (result, requestAggs) => {
  var _result$aggregations;
  const aggregations = (_result$aggregations = result.aggregations) !== null && _result$aggregations !== void 0 ? _result$aggregations : {};
  return {
    stats_over_interval: (0, _rule_execution_stats.normalizeRuleExecutionStatsAggregationResult)(aggregations, 'whole-interval'),
    history_over_interval: normalizeHistoryOverInterval(aggregations),
    debug: {
      eventLog: {
        request: {
          aggs: requestAggs
        },
        response: {
          aggregations
        }
      }
    }
  };
};
exports.normalizeRuleHealthAggregationResult = normalizeRuleHealthAggregationResult;
const normalizeHistoryOverInterval = aggregations => {
  const statsHistory = aggregations.statsHistory || {};
  return {
    buckets: statsHistory.buckets.map(rawBucket => {
      const timestamp = String(rawBucket.key_as_string);
      const stats = (0, _rule_execution_stats.normalizeRuleExecutionStatsAggregationResult)(rawBucket, 'histogram');
      return {
        timestamp,
        stats
      };
    })
  };
};