"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildContext = void 0;
var _messages = require("@langchain/core/messages");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _inspect_index_mapping_tool = require("../../../../tools/inspect_index_mapping_tool/inspect_index_mapping_tool");
var _common = require("../../../../utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildContext = messages => {
  const orderedInspectIndexMappingToolCalls = messages.filter(message => (0, _common.messageContainsToolCalls)(message)).flatMap(message => message.tool_calls).filter(toolCall => toolCall !== undefined).filter(toolCall => toolCall.name === _inspect_index_mapping_tool.toolDetails.name);
  const orderedInspectIndexMappingToolCallIds = orderedInspectIndexMappingToolCalls.map(toolCall => toolCall.id);
  const inspectIndexMappingToolCallByIds = orderedInspectIndexMappingToolCalls.reduce((acc, toolCall) => {
    const toolCallId = toolCall.id;
    if (toolCallId !== undefined) {
      acc[toolCallId] = toolCall;
    }
    return acc;
  }, {});
  const orderedInspectIndexMappingToolMessages = messages.filter(message => message instanceof _messages.ToolMessage).filter(message => message.tool_call_id in inspectIndexMappingToolCallByIds).map(message => message).sort((a, b) => orderedInspectIndexMappingToolCallIds.indexOf(a.tool_call_id) - orderedInspectIndexMappingToolCallIds.indexOf(b.tool_call_id));
  let context = {};
  /* eslint-disable no-continue */

  for (const toolMessage of orderedInspectIndexMappingToolMessages) {
    const toolCall = inspectIndexMappingToolCallByIds[toolMessage.tool_call_id];
    if (toolCall.args.property !== undefined) {
      if (toolCall.args.property === '') {
        try {
          context = JSON.parse(toolMessage.content);
        } catch (e) {
          continue;
        }
      } else {
        try {
          const parsedContent = JSON.parse(toolMessage.content);
          (0, _saferLodashSet.set)(context, toolCall.args.property, parsedContent);
        } catch (e) {
          continue;
        }
      }
    }
  }

  /* eslint-enable no-continue */

  return context;
};
exports.buildContext = buildContext;