"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineCallout = exports.SAVE_TIMELINE_CALLOUT_TITLE = exports.SAVE_TIMELINE_CALLOUT_CONTENT = exports.SAVE_TIMELINE_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _test_ids = require("./test_ids");
var _types = require("../../../../common/types");
var _save_timeline_button = require("../modal/actions/save_timeline_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVE_TIMELINE_CALLOUT_TITLE = exports.SAVE_TIMELINE_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.notes.saveTimeline.calloutTitle', {
  defaultMessage: 'Save Timeline'
});
const SAVE_TIMELINE_CALLOUT_CONTENT = exports.SAVE_TIMELINE_CALLOUT_CONTENT = _i18n.i18n.translate('xpack.securitySolution.timeline.notes.saveTimeline.calloutContent', {
  defaultMessage: 'You must save this Timeline before attaching notes to it.'
});
const SAVE_TIMELINE_BUTTON = exports.SAVE_TIMELINE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.saveTimeline.buttonLabel', {
  defaultMessage: 'Save Timeline'
});

/**
 * Renders a callout to let the user know they have to save the timeline before creating notes
 */
const SaveTimelineCallout = exports.SaveTimelineCallout = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: SAVE_TIMELINE_CALLOUT_TITLE,
    color: "danger",
    iconType: "info",
    "data-test-subj": _test_ids.SAVE_TIMELINE_CALLOUT_TEST_ID,
    css: (0, _react2.css)`
        margin-left: 50px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, SAVE_TIMELINE_CALLOUT_CONTENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: _types.TimelineId.active,
    buttonText: SAVE_TIMELINE_BUTTON,
    buttonColor: "danger",
    "data-test-subj": _test_ids.SAVE_TIMELINE_BUTTON_TEST_ID
  }))));
});
SaveTimelineCallout.displayName = 'SaveTimelineCallout';