"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationsTile = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _esql_query = require("./esql_query");
var _key_insights_tile = require("../common/key_insights_tile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationsTile = ({
  spaceId,
  sourcerDataView
}) => {
  return /*#__PURE__*/_react.default.createElement(_key_insights_tile.KeyInsightsTile, {
    title: _i18n.i18n.translate('xpack.securitySolution.privmon.authentications.title', {
      defaultMessage: 'Authentications'
    }),
    label: _i18n.i18n.translate('xpack.securitySolution.privmon.authentications.label', {
      defaultMessage: 'Authentications'
    }),
    getEsqlQuery: namespace => (0, _esql_query.getAuthenticationsEsqlCount)(namespace, sourcerDataView),
    id: "privileged-user-monitoring-authentications",
    spaceId: spaceId,
    inspectTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.privmon.authentications.inspectTitle",
      defaultMessage: "Authentications"
    })
  });
};
exports.AuthenticationsTile = AuthenticationsTile;