"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlogPostPrebuiltRuleCustomizationCallout = BlogPostPrebuiltRuleCustomizationCallout;
var _react = _interopRequireWildcard(require("react"));
var _avc_banner_background = _interopRequireDefault(require("@kbn/avc-banner/src/avc_banner_background.svg"));
var _eui = require("@elastic/eui");
var _use_callout_storage = require("../../../../common/components/callouts/use_callout_storage");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _background_image_callout = require("../background_image_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BlogPostPrebuiltRuleCustomizationCallout() {
  const blogPostUrl = (0, _kibana.useKibana)().services.docLinks.links.securitySolution.prebuiltRuleCustomizationPromoBlog;
  const calloutMessage = (0, _react.useMemo)(() => ({
    type: 'success',
    id: 'blog-post-elastic-security-prebuilt-rule-customization',
    title: i18n.CALLOUT_TITLE,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.CALLOUT_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "success",
      href: blogPostUrl,
      target: "_blank"
    }, i18n.CALLOUT_ACTION_BUTTON_LABEL))
  }), [blogPostUrl]);
  const {
    isVisible,
    dismiss
  } = (0, _use_callout_storage.useCallOutStorage)([calloutMessage], 'detections');
  const handleDismiss = (0, _react.useCallback)(() => {
    dismiss(calloutMessage);
  }, [dismiss, calloutMessage]);
  if (isVisible(calloutMessage)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_background_image_callout.BackgroundImageCallout, {
      backgroundImage: _avc_banner_background.default,
      title: calloutMessage.title,
      description: calloutMessage.description,
      color: calloutMessage.type,
      iconType: "cheer",
      onDismiss: handleDismiss
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
  return null;
}