"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MiniAttackChain = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _helpers = require("../../../../../../helpers");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MiniAttackChainComponent = ({
  attackDiscovery
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tactics = (0, _react2.useMemo)(() => (0, _helpers.getTacticMetadata)(attackDiscovery), [attackDiscovery]);
  const detectedTactics = (0, _react2.useMemo)(() => tactics.filter(tactic => tactic.detected), [tactics]);
  const detectedTacticsList = (0, _react2.useMemo)(() => detectedTactics.map(({
    name
  }) => /*#__PURE__*/_react2.default.createElement("li", {
    key: name
  }, ' - ', name)), [detectedTactics]);
  const tooltipContent = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("p", null, (0, _translations.ATTACK_CHAIN_TOOLTIP)(detectedTactics.length)), /*#__PURE__*/_react2.default.createElement("ul", null, detectedTacticsList)), [detectedTactics.length, detectedTacticsList]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    "data-test-subj": "miniAttackChainToolTip",
    position: "top"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          min-width: 140px;
        `,
    "data-test-subj": "miniAttackChain",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, tactics.map(({
    name,
    detected
  }) => {
    var _euiTheme$colors, _euiTheme$colors2;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: name
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      css: (0, _react.css)`
                color: ${detected ? (_euiTheme$colors = euiTheme.colors) === null || _euiTheme$colors === void 0 ? void 0 : _euiTheme$colors.danger : (_euiTheme$colors2 = euiTheme.colors) === null || _euiTheme$colors2 === void 0 ? void 0 : _euiTheme$colors2.subduedText};
                font-size: ${detected ? '14px' : '8px'};
                font-weight: ${detected ? euiTheme.font.weight.bold : euiTheme.font.weight.regular};
                margin-right: ${euiTheme.size.xs};
              `,
      "data-test-subj": "circle"
    }, 'o'));
  })));
};
MiniAttackChainComponent.displayName = 'MiniAttackChain';
const MiniAttackChain = exports.MiniAttackChain = /*#__PURE__*/_react2.default.memo(MiniAttackChainComponent);